/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.pkl.core.PClass;
import org.pkl.core.PObject;
import org.pkl.core.TypeAlias;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;

public final class ModuleSchema {
    private final URI moduleUri;
    private final String moduleName;
    private final boolean isAmend;
    private final @Nullable ModuleSchema supermodule;
    private final PClass moduleClass;
    private final @Nullable String docComment;
    private final List<PObject> annotations;
    private final Map<String, PClass> classes;
    private final Map<String, TypeAlias> typeAliases;
    private final Map<String, URI> imports;
    @LateInit
    private Map<String, PClass> __allClasses;
    @LateInit
    private Map<String, TypeAlias> __allTypeAliases;

    public ModuleSchema(URI moduleUri, String moduleName, boolean isAmend, @Nullable ModuleSchema supermodule, PClass moduleClass, @Nullable String docComment, List<PObject> annotations, Map<String, PClass> classes, Map<String, TypeAlias> typeAliases, Map<String, URI> imports) {
        this.moduleUri = moduleUri;
        this.moduleName = moduleName;
        this.isAmend = isAmend;
        this.supermodule = supermodule;
        this.moduleClass = moduleClass;
        this.docComment = docComment;
        this.annotations = annotations;
        this.classes = classes;
        this.typeAliases = typeAliases;
        this.imports = imports;
    }

    public URI getModuleUri() {
        return this.moduleUri;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getShortModuleName() {
        int index = this.moduleName.lastIndexOf(46);
        return this.moduleName.substring(index + 1);
    }

    public @Nullable ModuleSchema getSupermodule() {
        return this.supermodule;
    }

    public boolean isAmend() {
        return this.isAmend;
    }

    public boolean isExtend() {
        return this.supermodule != null && !this.isAmend;
    }

    public @Nullable String getDocComment() {
        return this.docComment;
    }

    public List<PObject> getAnnotations() {
        return this.annotations;
    }

    public PClass getModuleClass() {
        return this.moduleClass;
    }

    public Map<String, URI> getImports() {
        return this.imports;
    }

    public Map<String, PClass> getClasses() {
        return this.classes;
    }

    public Map<String, PClass> getAllClasses() {
        if (this.__allClasses == null) {
            if (this.supermodule == null) {
                this.__allClasses = this.classes;
            } else if (this.classes.isEmpty()) {
                this.__allClasses = this.supermodule.getAllClasses();
            } else {
                this.__allClasses = new LinkedHashMap<String, PClass>();
                this.__allClasses.putAll(this.supermodule.getAllClasses());
                this.__allClasses.putAll(this.classes);
            }
        }
        return this.__allClasses;
    }

    public Map<String, TypeAlias> getTypeAliases() {
        return this.typeAliases;
    }

    public Map<String, TypeAlias> getAllTypeAliases() {
        if (this.__allTypeAliases == null) {
            if (this.supermodule == null) {
                this.__allTypeAliases = this.typeAliases;
            } else if (this.typeAliases.isEmpty()) {
                this.__allTypeAliases = this.supermodule.getAllTypeAliases();
            } else {
                this.__allTypeAliases = new LinkedHashMap<String, TypeAlias>();
                this.__allTypeAliases.putAll(this.supermodule.getAllTypeAliases());
                this.__allTypeAliases.putAll(this.typeAliases);
            }
        }
        return this.__allTypeAliases;
    }
}

