/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import com.oracle.truffle.api.TruffleOptions;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.pkl.core.Evaluator;
import org.pkl.core.EvaluatorImpl;
import org.pkl.core.Logger;
import org.pkl.core.Loggers;
import org.pkl.core.OutputFormat;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagers;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.StackFrameTransformers;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.ModulePathResolver;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.project.Project;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.resource.ResourceReaders;
import org.pkl.core.runtime.LoggerImpl;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public final class EvaluatorBuilder {
    private final SecurityManagers.StandardBuilder securityManagerBuilder = SecurityManagers.standardBuilder();
    private @Nullable SecurityManager securityManager;
    private Logger logger = Loggers.noop();
    private final List<ModuleKeyFactory> moduleKeyFactories = new ArrayList<ModuleKeyFactory>();
    private final List<ResourceReader> resourceReaders = new ArrayList<ResourceReader>();
    private final Map<String, String> environmentVariables = new HashMap<String, String>();
    private final Map<String, String> externalProperties = new HashMap<String, String>();
    private @Nullable Duration timeout;
    private @Nullable Path moduleCacheDir = IoUtils.getDefaultModuleCacheDir();
    private @Nullable String outputFormat;
    private @Nullable StackFrameTransformer stackFrameTransformer;
    private @Nullable DeclaredDependencies dependencies;

    private EvaluatorBuilder() {
    }

    public static EvaluatorBuilder preconfigured() {
        EvaluatorBuilder builder = new EvaluatorBuilder();
        builder.setStackFrameTransformer(StackFrameTransformers.defaultTransformer).setAllowedModules(SecurityManagers.defaultAllowedModules).setAllowedResources(SecurityManagers.defaultAllowedResources).addResourceReader(ResourceReaders.environmentVariable()).addResourceReader(ResourceReaders.externalProperty()).addResourceReader(ResourceReaders.file()).addResourceReader(ResourceReaders.http()).addResourceReader(ResourceReaders.https()).addResourceReader(ResourceReaders.pkg()).addResourceReader(ResourceReaders.projectpackage()).addModuleKeyFactory(ModuleKeyFactories.standardLibrary);
        if (!TruffleOptions.AOT) {
            ClassLoader classLoader = EvaluatorBuilder.class.getClassLoader();
            builder.addModuleKeyFactory(ModuleKeyFactories.classPath(classLoader)).addResourceReader(ResourceReaders.classPath(classLoader));
            EvaluatorBuilder.addSystemProperties(builder);
        }
        builder.addModuleKeyFactories(ModuleKeyFactories.fromServiceProviders()).addModuleKeyFactory(ModuleKeyFactories.file).addModuleKeyFactory(ModuleKeyFactories.pkg).addModuleKeyFactory(ModuleKeyFactories.projectpackage).addModuleKeyFactory(ModuleKeyFactories.genericUrl).addEnvironmentVariables(System.getenv());
        return builder;
    }

    private static void addSystemProperties(EvaluatorBuilder builder) {
        builder.addExternalProperties(System.getProperties());
    }

    public static EvaluatorBuilder unconfigured() {
        return new EvaluatorBuilder();
    }

    public EvaluatorBuilder setStackFrameTransformer(StackFrameTransformer stackFrameTransformer) {
        this.stackFrameTransformer = stackFrameTransformer;
        return this;
    }

    public @Nullable StackFrameTransformer getStackFrameTransformer() {
        return this.stackFrameTransformer;
    }

    public EvaluatorBuilder setSecurityManager(@Nullable SecurityManager manager) {
        this.securityManager = manager;
        return this;
    }

    public EvaluatorBuilder unsetSecurityManager() {
        this.securityManager = null;
        return this;
    }

    public @Nullable SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public EvaluatorBuilder setAllowedModules(Collection<Pattern> patterns) {
        if (this.securityManager != null) {
            throw new IllegalStateException("Cannot call both `setSecurityManager` and `setAllowedModules`, because both define security manager settings.");
        }
        this.securityManagerBuilder.setAllowedModules((Collection)patterns);
        return this;
    }

    public List<Pattern> getAllowedModules() {
        return this.securityManagerBuilder.getAllowedModules();
    }

    public EvaluatorBuilder setAllowedResources(Collection<Pattern> patterns) {
        if (this.securityManager != null) {
            throw new IllegalStateException("Cannot call both `setSecurityManager` and `setAllowedResources`, because both define security manager settings.");
        }
        this.securityManagerBuilder.setAllowedResources((Collection)patterns);
        return this;
    }

    public List<Pattern> getAllowedResources() {
        return this.securityManagerBuilder.getAllowedResources();
    }

    public EvaluatorBuilder setRootDir(@Nullable Path rootDir) {
        this.securityManagerBuilder.setRootDir(rootDir);
        return this;
    }

    public @Nullable Path getRootDir() {
        return this.securityManagerBuilder.getRootDir();
    }

    public EvaluatorBuilder setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public EvaluatorBuilder addModuleKeyFactory(ModuleKeyFactory factory) {
        this.moduleKeyFactories.add(factory);
        return this;
    }

    public EvaluatorBuilder addModuleKeyFactories(Collection<ModuleKeyFactory> factories) {
        this.moduleKeyFactories.addAll(factories);
        return this;
    }

    public EvaluatorBuilder setModuleKeyFactories(Collection<ModuleKeyFactory> factories) {
        this.moduleKeyFactories.clear();
        return this.addModuleKeyFactories(factories);
    }

    public List<ModuleKeyFactory> getModuleKeyFactories() {
        return this.moduleKeyFactories;
    }

    public EvaluatorBuilder addResourceReader(ResourceReader reader) {
        this.resourceReaders.add(reader);
        return this;
    }

    public EvaluatorBuilder addResourceReaders(Collection<ResourceReader> readers) {
        this.resourceReaders.addAll(readers);
        return this;
    }

    public EvaluatorBuilder setResourceReaders(Collection<ResourceReader> readers) {
        this.resourceReaders.clear();
        return this.addResourceReaders(readers);
    }

    public List<ResourceReader> getResourceReaders() {
        return this.resourceReaders;
    }

    public EvaluatorBuilder addEnvironmentVariable(String name, String value2) {
        this.environmentVariables.put(name, value2);
        return this;
    }

    public EvaluatorBuilder addEnvironmentVariables(Map<String, String> envVars) {
        this.environmentVariables.putAll(envVars);
        return this;
    }

    public EvaluatorBuilder setEnvironmentVariables(Map<String, String> envVars) {
        this.environmentVariables.clear();
        return this.addEnvironmentVariables(envVars);
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public EvaluatorBuilder addExternalProperty(String name, String value2) {
        this.externalProperties.put(name, value2);
        return this;
    }

    public EvaluatorBuilder addExternalProperties(Map<String, String> properties) {
        this.externalProperties.putAll(properties);
        return this;
    }

    public EvaluatorBuilder setExternalProperties(Map<String, String> properties) {
        this.externalProperties.clear();
        return this.addExternalProperties(properties);
    }

    public Map<String, String> getExternalProperties() {
        return this.externalProperties;
    }

    public EvaluatorBuilder setTimeout(@Nullable Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public @Nullable Duration getTimeout() {
        return this.timeout;
    }

    public EvaluatorBuilder setModuleCacheDir(@Nullable Path moduleCacheDir) {
        this.moduleCacheDir = moduleCacheDir;
        return this;
    }

    public @Nullable Path getModuleCacheDir() {
        return this.moduleCacheDir;
    }

    public EvaluatorBuilder setOutputFormat(@Nullable String outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public EvaluatorBuilder setOutputFormat(@Nullable OutputFormat outputFormat) {
        this.outputFormat = outputFormat == null ? null : outputFormat.toString();
        return this;
    }

    public @Nullable String getOutputFormat() {
        return this.outputFormat;
    }

    public EvaluatorBuilder setProjectDependencies(DeclaredDependencies dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public EvaluatorBuilder applyFromProject(Project project) {
        this.dependencies = project.getDependencies();
        Project.EvaluatorSettings settings = project.getSettings();
        if (this.securityManager != null) {
            throw new IllegalStateException("Cannot call both `setSecurityManager` and `setProject`, because both define security manager settings. Call `setProjectOnly` if the security manager is desired.");
        }
        if (settings.getAllowedModules() != null) {
            this.setAllowedModules(settings.getAllowedModules());
        }
        if (settings.getAllowedResources() != null) {
            this.setAllowedResources(settings.getAllowedResources());
        }
        if (settings.getExternalProperties() != null) {
            this.setExternalProperties(settings.getExternalProperties());
        }
        if (settings.getEnv() != null) {
            this.setEnvironmentVariables(settings.getEnv());
        }
        if (settings.getTimeout() != null) {
            this.setTimeout(settings.getTimeout().toJavaDuration());
        }
        if (settings.getModulePath() != null) {
            ModulePathResolver modulePathResolver = new ModulePathResolver(settings.getModulePath());
            this.addResourceReader(ResourceReaders.modulePath(modulePathResolver));
            this.addModuleKeyFactory(ModuleKeyFactories.modulePath(modulePathResolver));
        }
        if (settings.getRootDir() != null) {
            this.setRootDir(settings.getRootDir());
        }
        if (Boolean.TRUE.equals(settings.isNoCache())) {
            this.setModuleCacheDir(null);
        } else if (settings.getModuleCacheDir() != null) {
            this.setModuleCacheDir(settings.getModuleCacheDir());
        }
        return this;
    }

    public Evaluator build() {
        if (this.securityManager == null) {
            this.securityManager = this.securityManagerBuilder.build();
        }
        if (this.stackFrameTransformer == null) {
            throw new IllegalStateException("No stack frame transformer set.");
        }
        return new EvaluatorImpl(this.stackFrameTransformer, this.securityManager, new LoggerImpl(this.logger, this.stackFrameTransformer), new ArrayList<ModuleKeyFactory>(this.moduleKeyFactories), new ArrayList<ResourceReader>(this.resourceReaders), new HashMap<String, String>(this.environmentVariables), new HashMap<String, String>(this.externalProperties), this.timeout, this.moduleCacheDir, this.dependencies, this.outputFormat);
    }
}

