/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.pkl.core.util.Nullable;

public enum DurationUnit {
    NANOS(1L, "ns"),
    MICROS(1000L, "us"),
    MILLIS(1000000L, "ms"),
    SECONDS(1000000000L, "s"),
    MINUTES(60000000000L, "min"),
    HOURS(3600000000000L, "h"),
    DAYS(86400000000000L, "d");

    private final long nanos;
    private final String symbol;

    private DurationUnit(long nanos, String symbol) {
        this.nanos = nanos;
        this.symbol = symbol;
    }

    public static @Nullable DurationUnit parse(String symbol) {
        switch (symbol) {
            case "ns": {
                return NANOS;
            }
            case "us": {
                return MICROS;
            }
            case "ms": {
                return MILLIS;
            }
            case "s": {
                return SECONDS;
            }
            case "min": {
                return MINUTES;
            }
            case "h": {
                return HOURS;
            }
            case "d": {
                return DAYS;
            }
        }
        return null;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public long getNanos() {
        return this.nanos;
    }

    public ChronoUnit toChronoUnit() {
        switch (this) {
            case NANOS: {
                return ChronoUnit.NANOS;
            }
            case MICROS: {
                return ChronoUnit.MICROS;
            }
            case MILLIS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError((Object)("Unknown duration unit: " + this));
    }

    public TimeUnit toTimeUnit() {
        switch (this) {
            case NANOS: {
                return TimeUnit.NANOSECONDS;
            }
            case MICROS: {
                return TimeUnit.MICROSECONDS;
            }
            case MILLIS: {
                return TimeUnit.MILLISECONDS;
            }
            case SECONDS: {
                return TimeUnit.SECONDS;
            }
            case MINUTES: {
                return TimeUnit.MINUTES;
            }
            case HOURS: {
                return TimeUnit.HOURS;
            }
            case DAYS: {
                return TimeUnit.DAYS;
            }
        }
        throw new AssertionError((Object)("Unknown duration unit: " + this));
    }

    public String toString() {
        return this.symbol;
    }
}

