/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import com.oracle.truffle.api.TruffleOptions;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.pkl.core.PklBugException;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.runtime.ReaderBase;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Nullable;

public final class IoUtils {
    private static final Pattern uriLike = Pattern.compile("\\w+:.*");

    private IoUtils() {
    }

    public static URL toUrl(URI uri) throws IOException {
        try {
            return uri.toURL();
        }
        catch (Error e2) {
            if (e2.getClass().getName().equals("com.oracle.svm.core.jdk.UnsupportedFeatureError")) {
                throw new IOException("Unsupported protocol: " + uri.getScheme());
            }
            throw e2;
        }
    }

    public static boolean isUriLike(String str) {
        return uriLike.matcher(str).matches();
    }

    public static URI toUri(String str) throws URISyntaxException {
        return IoUtils.isUriLike(str) ? new URI(str) : new URI(null, null, str, null);
    }

    public static URI createUri(String str) {
        try {
            return IoUtils.toUri(str);
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException(e2.getMessage(), e2);
        }
    }

    public static URI stripFragment(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), null);
        }
        catch (URISyntaxException e2) {
            throw PklBugException.unreachableCode();
        }
    }

    public static String readString(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            String string = IoUtils.readString(stream);
            return string;
        }
    }

    public static String readString(InputStream inputStream) throws IOException {
        return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
    }

    public static byte[] readBytes(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
    }

    public static String readString(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        int bytesRead = 0;
        char[] buffer = new char[8192];
        while ((bytesRead = reader.read(buffer, 0, buffer.length)) != -1) {
            builder.append(buffer, 0, bytesRead);
        }
        return builder.toString();
    }

    public static String readClassPathResourceAsString(Class<?> clazz, String path) throws IOException {
        InputStream inputStream = clazz.getResourceAsStream(path);
        if (inputStream == null) {
            throw new IOException(String.format("Cannot find class path resource `%s`.", path));
        }
        try (InputStream inputStream2 = inputStream;){
            String string = IoUtils.readString(inputStream);
            return string;
        }
    }

    public static void zipDirectory(final Path sourceDir, Path targetFile) throws IOException {
        try (final ZipOutputStream zipStream = new ZipOutputStream(new FileOutputStream(targetFile.toFile()));){
            Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    zipStream.putNextEntry(new ZipEntry(sourceDir.relativize(file).toString()));
                    Files.copy(file, zipStream);
                    zipStream.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static Path getCurrentWorkingDir() {
        return Path.of(System.getProperty("user.dir"), new String[0]);
    }

    public static Path getPklHomeDir() {
        return Path.of(System.getProperty("user.home"), ".pkl");
    }

    public static Path getDefaultModuleCacheDir() {
        return IoUtils.getPklHomeDir().resolve("cache");
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getName(String path) {
        int lastSep = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        return path.substring(lastSep + 1);
    }

    public static String getName(Path path) {
        return IoUtils.getName(path.toString());
    }

    public static String getNameWithoutExtension(String path) {
        int lastSep = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        int lastDot = path.lastIndexOf(46);
        return lastDot == -1 || lastDot < lastSep ? path.substring(lastSep + 1) : path.substring(lastSep + 1, lastDot);
    }

    public static String takeLastSegment(String name, char separator) {
        int lastSep = name.lastIndexOf(separator);
        return name.substring(lastSep + 1);
    }

    public static String dropLastSegment(String name, char separator) {
        int lastSep = name.lastIndexOf(separator);
        return lastSep == -1 ? name : name.substring(0, lastSep);
    }

    public static @Nullable Path toPath(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("Expected absolute URI, but got: " + uri);
        }
        try {
            return Path.of(uri);
        }
        catch (IllegalArgumentException | FileSystemNotFoundException e2) {
            return null;
        }
    }

    private static String doInferModuleName(URI moduleUri) {
        String path = moduleUri.getPath();
        if (path == null) {
            return IoUtils.takeLastSegment(IoUtils.dropLastSegment(moduleUri.getSchemeSpecificPart(), ':'), '.');
        }
        return IoUtils.getNameWithoutExtension(path);
    }

    public static String inferModuleName(ModuleKey moduleKey) {
        URI moduleUri = moduleKey.getUri();
        if ("jar".equalsIgnoreCase(moduleUri.getScheme())) {
            String uriString = moduleUri.toString();
            int index = IoUtils.getExclamationMarkIndex(uriString);
            String path = uriString.substring(index + 1);
            return IoUtils.getNameWithoutExtension(path);
        }
        if (moduleKey.hasFragmentPaths()) {
            String fragment = moduleUri.getFragment();
            return IoUtils.getNameWithoutExtension(fragment);
        }
        return IoUtils.doInferModuleName(moduleUri);
    }

    public static URI ensurePathEndsWithSlash(URI uri) {
        try {
            if (uri.isOpaque()) {
                return uri;
            }
            if (uri.getPath().endsWith("/")) {
                return uri;
            }
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath() + "/", uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    public static URI resolve(ReaderBase reader, URI baseUri, String importUri) {
        return IoUtils.resolve(reader, baseUri, IoUtils.createUri(importUri));
    }

    public static URI resolve(ReaderBase reader, URI baseUri, URI importUri) {
        if (reader.hasFragmentPaths() && !importUri.isAbsolute() && importUri.getPath() != null) {
            String fragment = baseUri.getFragment();
            URI newFragment = IoUtils.resolve(IoUtils.createUri(fragment), importUri);
            return IoUtils.stripFragment(baseUri).resolve("#" + newFragment);
        }
        return IoUtils.resolve(baseUri, importUri);
    }

    public static URI resolve(SecurityManager securityManager, ModuleKey moduleKey, URI importUri) throws URISyntaxException, IOException, SecurityManagerException {
        URI candidateUri;
        String candidatePath;
        if (importUri.isAbsolute()) {
            return moduleKey.resolveUri(importUri);
        }
        URI moduleKeyUri = moduleKey.getUri();
        String tripleDotPath = IoUtils.parseTripleDotPath(importUri);
        if (tripleDotPath == null) {
            return moduleKey.resolveUri(importUri);
        }
        if (!moduleKey.isLocal() || !moduleKey.hasHierarchicalUris()) {
            throw new VmExceptionBuilder().evalError("cannotResolveTripleDotImports", moduleKeyUri).build();
        }
        String currentPath = moduleKey.hasFragmentPaths() ? moduleKeyUri.getFragment() : moduleKeyUri.getPath();
        String effectiveImportPath = tripleDotPath.isEmpty() ? currentPath.substring(currentPath.lastIndexOf(47) + 1) : tripleDotPath;
        int index = currentPath.lastIndexOf(47);
        index = currentPath.lastIndexOf(47, index - 1);
        String basePath = currentPath;
        while (index > 0) {
            basePath = basePath.substring(0, index + 1);
            candidatePath = basePath + effectiveImportPath;
            candidateUri = IoUtils.resolve((ReaderBase)moduleKey, moduleKeyUri, candidatePath);
            if (!candidatePath.equals(currentPath) && moduleKey.hasElement(securityManager, candidateUri)) {
                return IoUtils.fixTripleSlashUri(moduleKeyUri, candidateUri);
            }
            index = basePath.lastIndexOf(47, index - 1);
        }
        candidatePath = "/" + effectiveImportPath;
        candidateUri = IoUtils.resolve((ReaderBase)moduleKey, moduleKeyUri, candidatePath);
        if (!candidatePath.equals(currentPath) && moduleKey.hasElement(securityManager, candidateUri)) {
            return IoUtils.fixTripleSlashUri(moduleKeyUri, candidateUri);
        }
        throw new FileNotFoundException();
    }

    public static URI resolve(URI baseUri, URI newUri) {
        if (newUri.isAbsolute()) {
            return newUri;
        }
        String scheme = baseUri.getScheme();
        if ("jar".equalsIgnoreCase(scheme)) {
            String baseUriString = baseUri.toString();
            int index = IoUtils.getExclamationMarkIndex(baseUriString);
            String jarUri = baseUriString.substring(0, index + 1);
            String jarPath = baseUriString.substring(index + 1);
            URI resolvedPath = IoUtils.resolve(URI.create(jarPath), newUri);
            return URI.create(jarUri + resolvedPath);
        }
        return IoUtils.fixTripleSlashUri(baseUri, baseUri.resolve(newUri));
    }

    public static URI resolve(URI uri, String str) {
        try {
            return IoUtils.resolve(uri, IoUtils.toUri(str));
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException(e2.getMessage(), e2);
        }
    }

    public static URI relativize(URI uri, URI base) {
        if (uri.isOpaque() || base.isOpaque() || !Objects.equals(uri.getScheme(), base.getScheme()) || !Objects.equals(uri.getAuthority(), base.getAuthority())) {
            return uri;
        }
        Path basePath = Path.of(base.getPath(), new String[0]);
        if (!base.getRawPath().endsWith("/")) {
            basePath = basePath.getParent();
        }
        Path resultPath = basePath.relativize(Path.of(uri.getPath(), new String[0]));
        try {
            return new URI(null, null, null, -1, resultPath.toString(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static boolean isWhitespace(String str) {
        return str.codePoints().allMatch(Character::isWhitespace);
    }

    public static String capitalize(String str) {
        if (str.isEmpty()) {
            return str;
        }
        int cp = str.codePointAt(0);
        if (Character.isTitleCase(cp)) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        builder.appendCodePoint(Character.toTitleCase(cp));
        builder.append(str.substring(Character.charCount(cp)));
        return builder.toString();
    }

    public static int getMaxLineLength(String str) {
        return str.lines().map(String::length).max(Comparator.naturalOrder()).orElse(0);
    }

    public static <T> ServiceLoader<T> createServiceLoader(Class<T> serviceClass) {
        if (TruffleOptions.AOT) {
            return ServiceLoader.load(serviceClass);
        }
        return ServiceLoader.load(serviceClass, IoUtils.class.getClassLoader());
    }

    public static boolean isTestMode() {
        return Boolean.getBoolean("org.pkl.testMode");
    }

    public static void setTestMode() {
        System.setProperty("org.pkl.testMode", "true");
    }

    public static @Nullable String parseTripleDotPath(URI importUri) throws URISyntaxException {
        String importScheme = importUri.getScheme();
        if (importScheme != null) {
            return null;
        }
        String schemeSpecificPart = importUri.getSchemeSpecificPart();
        if (!schemeSpecificPart.startsWith("...")) {
            return null;
        }
        if (schemeSpecificPart.length() == 3) {
            return "";
        }
        if (schemeSpecificPart.charAt(3) != '/' || schemeSpecificPart.length() == 4) {
            throw new URISyntaxException(importUri.toString(), ErrorMessages.create("invalidTripleDotSyntax", new Object[0]));
        }
        return schemeSpecificPart.substring(4);
    }

    public static String toUnicodeEscape(int ch) {
        String hex = Integer.toHexString(ch);
        switch (hex.length()) {
            case 1: {
                return "\\u000" + hex;
            }
            case 2: {
                return "\\u00" + hex;
            }
            case 3: {
                return "\\u0" + hex;
            }
            case 4: {
                return "\\u" + hex;
            }
        }
        throw new IllegalArgumentException(String.valueOf(ch));
    }

    public static String toHexEscape(int ch) {
        String hex = Integer.toHexString(ch);
        switch (hex.length()) {
            case 1: {
                return "\\x0" + hex;
            }
            case 2: {
                return "\\x" + hex;
            }
        }
        throw new IllegalArgumentException(String.valueOf(ch));
    }

    public static boolean isHexDigit(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public static boolean isHexDigitOrUnderscore(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case '_': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public static boolean isDecimalDigit(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public static boolean isDecimalDigitOrUnderscore(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static boolean isNonZeroDecimalDigit(char ch) {
        switch (ch) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public static boolean isOctalDigit(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return true;
            }
        }
        return false;
    }

    public static boolean isOctalDigitOrUnderscore(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinaryDigitOrUnderscore(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    public static URI fixTripleSlashUri(URI baseUri, URI newUri) {
        if (baseUri.getScheme() != null && baseUri.getScheme().equalsIgnoreCase(newUri.getScheme()) && baseUri.getSchemeSpecificPart().startsWith("///") && newUri.getHost() == null) {
            try {
                return new URI(newUri.getScheme(), newUri.getUserInfo(), "", newUri.getPort(), newUri.getPath(), newUri.getQuery(), newUri.getFragment());
            }
            catch (URISyntaxException e2) {
                throw new IllegalArgumentException(e2.getMessage(), e2);
            }
        }
        return newUri;
    }

    private static int getExclamationMarkIndex(String jarUri) {
        int index = jarUri.indexOf(33);
        if (index == -1) {
            throw new IllegalArgumentException("Invalid `jar:` URI (missing `!`): " + jarUri);
        }
        return index;
    }
}

