/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import java.util.ArrayList;
import java.util.List;
import org.pkl.core.util.AbstractCharEscaper;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;

public final class ArrayCharEscaper
extends AbstractCharEscaper {
    private final char minEscape;
    private final @Nullable String[] replacements;

    private ArrayCharEscaper(char minEscape, String[] replacements) {
        this.minEscape = minEscape;
        this.replacements = replacements;
    }

    public static Builder builder(int maxAllowedSize) {
        return new Builder(maxAllowedSize);
    }

    public static Builder builder() {
        return new Builder(256);
    }

    @Override
    protected @Nullable String findReplacement(char ch) {
        int index = ch - this.minEscape;
        return index >= 0 && index < this.replacements.length ? this.replacements[index] : null;
    }

    public static class Builder {
        private final int maxAllowedSize;
        private final List<Pair<Character, String>> escapes = new ArrayList<Pair<Character, String>>();
        private char minEscape = (char)65535;
        private char maxEscape = '\u0000';

        private Builder(int maxAllowedSize) {
            this.maxAllowedSize = maxAllowedSize;
        }

        public Builder withEscape(char ch, String escape) {
            if (ch >= '\ud800') {
                throw new IllegalArgumentException(String.valueOf(ch));
            }
            this.escapes.add(Pair.of(Character.valueOf(ch), escape));
            if (ch < this.minEscape) {
                this.minEscape = ch;
            }
            if (ch > this.maxEscape) {
                this.maxEscape = ch;
            }
            return this;
        }

        public ArrayCharEscaper build() {
            int arraySize;
            int n = arraySize = this.escapes.isEmpty() ? 0 : this.maxEscape - this.minEscape + 1;
            if (arraySize > this.maxAllowedSize) {
                throw new IllegalStateException("Actual array size " + arraySize + " is greater than maximum allowed size " + this.maxAllowedSize);
            }
            String[] replacements = new String[arraySize];
            for (Pair<Character, String> pair : this.escapes) {
                replacements[((Character)pair.first).charValue() - this.minEscape] = (String)pair.second;
            }
            return new ArrayCharEscaper(this.minEscape, replacements);
        }
    }
}

