/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.yaml;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmSafeMath;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.yaml.snake.YamlUtils;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.api.Load;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.constructor.BaseConstructor;
import org.snakeyaml.engine.v2.constructor.StandardConstructor;
import org.snakeyaml.engine.v2.exceptions.Mark;
import org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.resolver.ScalarResolver;

public final class ParserNodes {
    private static final Pattern WHITESPACE = Pattern.compile("\\s");

    private ParserNodes() {
    }

    private static PklConverter createConverter(VmTyped self) {
        VmMapping converters = (VmMapping)VmUtils.readMember(self, Identifier.CONVERTERS);
        return new PklConverter(converters);
    }

    private static int getMaxCollectionAliases(VmTyped self) {
        Long max2 = (Long)VmUtils.readMember(self, Identifier.MAX_COLLECTION_ALIASES);
        return max2.intValue();
    }

    private static Load createLoad(VmTyped self, String text, String uri, PklConverter converter) {
        String mode = (String)VmUtils.readMember(self, Identifier.MODE);
        ScalarResolver resolver = YamlUtils.getParserResolver(mode);
        boolean useMapping = (Boolean)VmUtils.readMember(self, Identifier.USE_MAPPING);
        LoadSettings settings = LoadSettings.builder().setMaxAliasesForCollections(ParserNodes.getMaxCollectionAliases(self)).setScalarResolver(resolver).setLabel(uri).build();
        Source source = Source.newBuilder((String)"pkl", (CharSequence)text, (String)uri).mimeType("application/x-yaml").uri(URI.create(uri)).cached(false).build();
        return new Load(settings, (BaseConstructor)new Constructor(settings, source, converter, mode, useMapping));
    }

    private static final class Constructor
    extends StandardConstructor {
        private final Source source;
        private final PklConverter converter;
        private final boolean useMapping;
        private Deque<Object> currPath = new ArrayDeque<Object>();

        public Constructor(LoadSettings settings, Source source, PklConverter converter, String mode, boolean useMapping) {
            super(settings);
            this.source = source;
            this.converter = converter;
            this.useMapping = useMapping;
            this.currPath.push(VmValueConverter.TOP_LEVEL_VALUE);
            this.tagConstructors.clear();
            this.tagConstructors.put(Tag.NULL, new ConstructNull());
            this.tagConstructors.put(Tag.BOOL, new ConstructBoolean());
            this.tagConstructors.put(Tag.INT, new ConstructInt(mode.equals("compat") || mode.equals("1.1")));
            this.tagConstructors.put(Tag.FLOAT, new ConstructFloat());
            this.tagConstructors.put(Tag.BINARY, new ConstructBinary());
            this.tagConstructors.put(Tag.SET, new ConstructSet());
            this.tagConstructors.put(Tag.STR, new ConstructStr());
            this.tagConstructors.put(Tag.SEQ, new ConstructSeq());
            this.tagConstructors.put(Tag.MAP, new ConstructMap());
            this.tagConstructors.put(new Tag("tag:yaml.org,2002:timestamp"), new ConstructStr());
        }

        private SourceSection createSourceSection(Optional<Mark> start2, Optional<Mark> end2) {
            Source s2 = this.source;
            return VmUtils.unavailableSourceSection();
        }

        private class ConstructMap
        implements ConstructNode {
            private ConstructMap() {
            }

            public VmObject construct(Node node) {
                MappingNode mappingNode = (MappingNode)node;
                EconomicMap members = EconomicMaps.create(mappingNode.getValue().size());
                VmObject result = Constructor.this.useMapping ? new VmMapping(VmUtils.createEmptyMaterializedFrame(), BaseModule.getMappingClass().getPrototype(), (UnmodifiableEconomicMap<Object, ObjectMember>)members) : new VmDynamic(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getDynamicClass().getPrototype(), (UnmodifiableEconomicMap<Object, ObjectMember>)members, 0);
                if (!node.isRecursive()) {
                    this.addMembers(mappingNode, result);
                }
                return result;
            }

            public void constructRecursive(Node node, Object data) {
                if (!node.isRecursive()) {
                    throw new YamlEngineException("Unexpected recursive sequence structure. Node: " + node);
                }
                this.addMembers((MappingNode)node, (VmObject)data);
            }

            private void addMembers(MappingNode node, VmObject object) {
                EconomicMap members = (EconomicMap)object.getMembers();
                Deque<Object> valuePath = Constructor.this.currPath;
                ArrayDeque<Object> keyPath = new ArrayDeque<Object>();
                Constructor.this.flattenMapping(node);
                for (NodeTuple tuple : node.getValue()) {
                    Node keyNode = tuple.getKeyNode();
                    Node valueNode = tuple.getValueNode();
                    SourceSection sourceSection = Constructor.this.createSourceSection(keyNode.getStartMark(), valueNode.getEndMark());
                    SourceSection headerSection = Constructor.this.createSourceSection(keyNode.getStartMark(), keyNode.getEndMark());
                    Constructor.this.currPath = keyPath;
                    Object key2 = Constructor.this.constructObject(keyNode);
                    Object convertedKey = Constructor.this.converter.convert(key2, Constructor.this.currPath);
                    Constructor.this.currPath = valuePath;
                    Identifier memberName = convertedKey instanceof String && !Constructor.this.useMapping ? Identifier.get((String)convertedKey) : null;
                    ObjectMember member = new ObjectMember(sourceSection, headerSection, memberName == null ? 1024 : 0, memberName, "generated");
                    Constructor.this.currPath.push(key2 instanceof String ? Identifier.get((String)key2) : VmValueConverter.WILDCARD_PROPERTY);
                    Object value2 = Constructor.this.constructObject(valueNode);
                    Object convertedValue = Constructor.this.converter.convert(value2, Constructor.this.currPath);
                    member.initConstantValue(convertedValue);
                    Constructor.this.currPath.pop();
                    EconomicMaps.put(members, memberName != null ? memberName : convertedKey, member);
                }
            }
        }

        private class ConstructSet
        implements ConstructNode {
            private ConstructSet() {
            }

            public VmListing construct(Node node) {
                MappingNode mappingNode = (MappingNode)node;
                EconomicMap members = EconomicMaps.create(mappingNode.getValue().size());
                VmListing result = new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), (UnmodifiableEconomicMap<Object, ObjectMember>)members, EconomicMaps.size(members));
                if (!node.isRecursive()) {
                    this.addMembers(mappingNode, result);
                }
                return result;
            }

            public void constructRecursive(Node node, Object data) {
                if (!node.isRecursive()) {
                    throw new YamlEngineException("Unexpected recursive sequence structure. Node: " + node);
                }
                this.addMembers((MappingNode)node, (VmListing)data);
            }

            private void addMembers(MappingNode node, VmListing listing) {
                EconomicMap members = (EconomicMap)listing.getMembers();
                long index = 0L;
                Constructor.this.flattenMapping(node);
                Constructor.this.currPath.push(VmValueConverter.WILDCARD_ELEMENT);
                for (NodeTuple tuple : node.getValue()) {
                    Node keyNode = tuple.getKeyNode();
                    SourceSection sourceSection = Constructor.this.createSourceSection(keyNode.getStartMark(), keyNode.getEndMark());
                    ObjectMember member = new ObjectMember(sourceSection, sourceSection, 2048, null, String.valueOf(index));
                    member.initConstantValue(Constructor.this.converter.convert(Constructor.this.constructObject(keyNode), Constructor.this.currPath));
                    EconomicMaps.put(members, index++, member);
                }
                Constructor.this.currPath.pop();
            }
        }

        private class ConstructSeq
        implements ConstructNode {
            private ConstructSeq() {
            }

            public VmListing construct(Node node) {
                SequenceNode sequenceNode = (SequenceNode)node;
                EconomicMap members = EconomicMaps.create(sequenceNode.getValue().size());
                VmListing result = new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), (UnmodifiableEconomicMap<Object, ObjectMember>)members, EconomicMaps.size(members));
                if (!node.isRecursive()) {
                    this.addMembers(sequenceNode, result);
                }
                return result;
            }

            public void constructRecursive(Node node, Object data) {
                if (!node.isRecursive()) {
                    throw new YamlEngineException("Unexpected recursive sequence structure. Node: " + node);
                }
                this.addMembers((SequenceNode)node, (VmListing)data);
            }

            private void addMembers(SequenceNode node, VmListing listing) {
                EconomicMap members = (EconomicMap)listing.getMembers();
                long index = 0L;
                Constructor.this.currPath.push(VmValueConverter.WILDCARD_ELEMENT);
                for (Node childNode : node.getValue()) {
                    SourceSection sourceSection = Constructor.this.createSourceSection(childNode.getStartMark(), childNode.getEndMark());
                    ObjectMember member = new ObjectMember(sourceSection, sourceSection, 2048, null, String.valueOf(index));
                    member.initConstantValue(Constructor.this.converter.convert(Constructor.this.constructObject(childNode), Constructor.this.currPath));
                    EconomicMaps.put(members, index++, member);
                }
                Constructor.this.currPath.pop();
            }
        }

        private static class ConstructBinary
        implements ConstructNode {
            private ConstructBinary() {
            }

            public String construct(Node node) {
                String value2 = ((ScalarNode)node).getValue();
                return WHITESPACE.matcher(value2).replaceAll("");
            }
        }

        public static class ConstructFloat
        implements ConstructNode {
            public Double construct(Node node) {
                String value2 = ((ScalarNode)node).getValue().replace("_", "");
                if (value2.equals(".")) {
                    return 0.0;
                }
                if (value2.contains(":")) {
                    return ConstructFloat.parseBase60(value2);
                }
                switch (value2) {
                    case ".nan": 
                    case ".NaN": 
                    case ".NAN": {
                        return Double.NaN;
                    }
                    case ".inf": 
                    case ".Inf": 
                    case ".INF": 
                    case "+.inf": 
                    case "+.Inf": 
                    case "+.INF": {
                        return Double.POSITIVE_INFINITY;
                    }
                    case "-.inf": 
                    case "-.Inf": 
                    case "-.INF": {
                        return Double.NEGATIVE_INFINITY;
                    }
                }
                return Double.valueOf(value2);
            }

            private static double parseBase60(String value2) {
                String[] segments;
                boolean isNegative = value2.startsWith("-");
                if (isNegative || value2.startsWith("+")) {
                    value2 = value2.substring(1);
                }
                double result = 0.0;
                for (String segment : segments = value2.split(":")) {
                    double segmentNum = Double.parseDouble(segment);
                    result = VmSafeMath.add(VmSafeMath.multiply(result, 60.0), segmentNum);
                }
                if (isNegative) {
                    result = -result;
                }
                return result;
            }
        }

        private static class ConstructInt
        implements ConstructNode {
            final boolean enable11Octals;

            ConstructInt(boolean enable11Octals) {
                this.enable11Octals = enable11Octals;
            }

            public Long construct(Node node) {
                int offset;
                String value2 = ((ScalarNode)node).getValue().replace("_", "");
                char firstChar = value2.charAt(0);
                boolean isNegative = firstChar == '-';
                int n = offset = isNegative || firstChar == '+' ? 1 : 0;
                if (value2.contains(":")) {
                    return ConstructInt.parseBase60(value2, isNegative, offset);
                }
                int radix = 10;
                if (value2.charAt(offset) == '0' && value2.length() > offset + 1) {
                    switch (value2.charAt(offset + 1)) {
                        case 'b': {
                            radix = 2;
                            offset += 2;
                            break;
                        }
                        case 'o': {
                            radix = 8;
                            offset += 2;
                            break;
                        }
                        case 'x': {
                            radix = 16;
                            offset += 2;
                            break;
                        }
                        default: {
                            if (!this.enable11Octals) break;
                            radix = 8;
                            ++offset;
                        }
                    }
                }
                long result = Long.parseLong(value2, offset, value2.length(), radix);
                if (isNegative) {
                    result = -result;
                }
                return result;
            }

            private static long parseBase60(String value2, boolean isNegative, int offset) {
                String[] segments;
                long result = 0L;
                for (String segment : segments = value2.substring(offset).split(":")) {
                    long segmentNum = Long.parseLong(segment);
                    result = VmSafeMath.add(VmSafeMath.multiply(result, 60L), segmentNum);
                }
                if (isNegative) {
                    result = -result;
                }
                return result;
            }
        }

        private static class ConstructNull
        implements ConstructNode {
            private ConstructNull() {
            }

            public VmNull construct(Node node) {
                return VmNull.withoutDefault();
            }
        }

        public static class ConstructStr
        implements ConstructNode {
            public Object construct(Node node) {
                return ((ScalarNode)node).getValue();
            }
        }

        public static class ConstructBoolean
        implements ConstructNode {
            public Object construct(Node node) {
                String value2;
                switch (value2 = ((ScalarNode)node).getValue()) {
                    case "true": 
                    case "True": 
                    case "TRUE": 
                    case "on": 
                    case "On": 
                    case "ON": 
                    case "y": 
                    case "Y": 
                    case "yes": 
                    case "Yes": 
                    case "YES": {
                        return true;
                    }
                }
                return false;
            }
        }
    }

    public static abstract class parseAll
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmList eval(VmTyped self, String text) {
            String uri = "input_string";
            return this.doParseAll(self, text, uri);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object eval(VmTyped self, VmTyped resource, @Cached(value="create()") IndirectCallNode callNode) {
            String text = (String)VmUtils.readMember(resource, Identifier.TEXT, callNode);
            String uri = (String)VmUtils.readMember(resource, Identifier.URI, callNode);
            return this.doParseAll(self, text, uri);
        }

        private VmList doParseAll(VmTyped self, String text, String uri) {
            PklConverter converter = ParserNodes.createConverter(self);
            Load load = ParserNodes.createLoad(self, text, uri, converter);
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            try {
                for (Object document : load.loadAllFromString(text)) {
                    builder.add(converter.convert(document, List.of(VmValueConverter.TOP_LEVEL_VALUE)));
                }
            }
            catch (YamlEngineException e2) {
                if (e2.getMessage().startsWith("Number of aliases for non-scalar nodes exceeds the specified")) {
                    throw this.exceptionBuilder().evalError("yamlParseErrorTooManyAliases", ParserNodes.getMaxCollectionAliases(self)).build();
                }
                throw this.exceptionBuilder().evalError("yamlParseError", new Object[0]).withHint(e2.getMessage()).build();
            }
            return builder.build();
        }
    }

    public static abstract class parse
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object eval(VmTyped self, String text) {
            String uri = "input_string";
            return this.doParse(self, text, uri);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object eval(VmTyped self, VmTyped resource, @Cached(value="create()") IndirectCallNode callNode) {
            String text = (String)VmUtils.readMember(resource, Identifier.TEXT, callNode);
            String uri = (String)VmUtils.readMember(resource, Identifier.URI, callNode);
            return this.doParse(self, text, uri);
        }

        private Object doParse(VmTyped self, String text, String uri) {
            PklConverter converter = ParserNodes.createConverter(self);
            Load load = ParserNodes.createLoad(self, text, uri, converter);
            try {
                Object document = load.loadFromString(text);
                return converter.convert(document, List.of());
            }
            catch (YamlEngineException e2) {
                if (e2.getMessage().startsWith("Number of aliases for non-scalar nodes exceeds the specified")) {
                    throw this.exceptionBuilder().evalError("yamlParseErrorTooManyAliases", ParserNodes.getMaxCollectionAliases(self)).build();
                }
                throw this.exceptionBuilder().evalError("yamlParseError", new Object[0]).withHint(e2.getMessage()).build();
            }
        }
    }
}

