/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.xml;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.XmlModule;
import org.pkl.core.stdlib.AbstractRenderer;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.util.ArrayCharEscaper;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.xml.XmlValidator;

public final class RendererNodes {
    private RendererNodes() {
    }

    private static Renderer createRenderer(VmTyped self, StringBuilder builder) {
        String indent = (String)VmUtils.readMember(self, Identifier.INDENT);
        String xmlVersion = (String)VmUtils.readMember(self, Identifier.XML_VERSION);
        String rootElementName = (String)VmUtils.readMember(self, Identifier.ROOT_ELEMENT_NAME);
        VmMapping rootElementAttributes = (VmMapping)VmUtils.readMember(self, Identifier.ROOT_ELEMENT_ATTRIBUTES);
        VmMapping converters = (VmMapping)VmUtils.readMember(self, Identifier.CONVERTERS);
        PklConverter converter = new PklConverter(converters);
        return new Renderer(builder, indent, xmlVersion, rootElementName, rootElementAttributes, converter);
    }

    private static boolean isBlockFormat(VmObjectLike object) {
        return (Boolean)VmUtils.readMember(object, Identifier.IS_BLOCK_FORMAT);
    }

    public static final class Renderer
    extends AbstractRenderer {
        private static final ArrayCharEscaper stringEscaper = ArrayCharEscaper.builder().withEscape('\"', "&quot;").withEscape('\'', "&apos;").withEscape('<', "&lt;").withEscape('>', "&gt;").withEscape('&', "&amp;").build();
        private final String version;
        private final String rootElementName;
        private final VmMapping rootElementAttributes;
        private final XmlValidator validator;
        private int lineNumber = 0;
        private @Nullable Object deferredKey;

        public Renderer(StringBuilder builder, String indent, String version, String rootElementName, VmMapping rootElementAttributes, PklConverter converter) {
            super("XML", builder, indent, converter, true, true);
            this.version = version;
            this.rootElementName = rootElementName;
            this.rootElementAttributes = rootElementAttributes;
            this.validator = XmlValidator.create(version);
        }

        @Override
        public void visitDocument(Object value2) {
            this.builder.append("<?xml version=\"").append(stringEscaper.escape(this.version)).append("\" encoding=\"UTF-8\"?>");
            if (Renderer.isXmlElement(value2)) {
                this.renderXmlElement((VmDynamic)value2);
            } else {
                this.writeXmlElement(this.rootElementName, this.rootElementAttributes, value2, true, true);
            }
            this.builder.append('\n');
        }

        @Override
        public void visitTopLevelValue(Object value2) {
            if (Renderer.isXmlElement(value2)) {
                this.renderXmlElement((VmDynamic)value2);
            } else {
                this.visit(value2);
            }
        }

        @Override
        protected void visitRenderDirective(VmTyped value2) {
            this.builder.append(VmUtils.readTextProperty(value2));
        }

        @Override
        public void visitString(String value2) {
            this.builder.append(stringEscaper.escape(value2));
        }

        @Override
        public void visitInt(Long value2) {
            this.builder.append(value2);
        }

        @Override
        public void visitFloat(Double value2) {
            this.builder.append(value2);
        }

        @Override
        public void visitBoolean(Boolean value2) {
            this.builder.append(value2);
        }

        @Override
        public void visitDuration(VmDuration value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitDataSize(VmDataSize value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitPair(VmPair value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitRegex(VmRegex value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitIntSeq(VmIntSeq value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        protected void startDynamic(VmDynamic value2) {
            if (Renderer.isXmlElement(value2)) {
                throw new VmExceptionBuilder().evalError("elementNotSupportedHere", new Object[0]).withProgramValue("Value", value2).build();
            }
        }

        @Override
        public void startTyped(VmTyped value2) {
            if (this.isXmlInline(value2)) {
                throw new VmExceptionBuilder().evalError("inlineNotSupportedHere", new Object[0]).withProgramValue("Value", value2).build();
            }
        }

        @Override
        protected void startListing(VmListing value2) {
        }

        @Override
        protected void startMapping(VmMapping value2) {
        }

        @Override
        protected void startList(VmList value2) {
        }

        @Override
        protected void startSet(VmSet value2) {
        }

        @Override
        protected void startMap(VmMap value2) {
        }

        @Override
        public void visitNull(VmNull value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        protected void visitProperty(Identifier name, Object value2, boolean isFirst) {
            if (Renderer.isXmlElement(value2)) {
                this.renderXmlElement((VmDynamic)value2);
            } else if (this.isXmlInline(value2)) {
                this.renderXmlInline((VmTyped)value2);
            } else {
                this.writeXmlElement(name.toString(), null, value2, true, true);
            }
        }

        @Override
        protected void endDynamic(VmDynamic value2, boolean isEmpty2) {
        }

        @Override
        protected void endTyped(VmTyped value2, boolean isEmpty2) {
        }

        @Override
        protected void endListing(VmListing value2, boolean isEmpty2) {
        }

        @Override
        protected void endMapping(VmMapping value2, boolean isEmpty2) {
        }

        @Override
        protected void endList(VmList value2) {
        }

        @Override
        protected void endSet(VmSet value2) {
        }

        @Override
        protected void endMap(VmMap value2) {
        }

        private void doVisitElement(Object value2) {
            if (!(value2 instanceof VmNull)) {
                if (Renderer.isXmlElement(value2)) {
                    this.renderXmlElement((VmDynamic)value2);
                } else if (this.isXmlInline(value2)) {
                    this.renderXmlInline((VmTyped)value2);
                } else if (Renderer.isContent(value2)) {
                    this.visit(value2);
                } else if (VmUtils.isRenderDirective(value2)) {
                    this.builder.append(VmUtils.readTextProperty(value2));
                } else {
                    this.writeXmlElement(VmUtils.getClass(value2).getSimpleName(), null, value2, true, true);
                }
            }
        }

        @Override
        protected void visitElement(long index, Object value2, boolean isFirst) {
            this.doVisitElement(value2);
        }

        @Override
        protected void visitEntryKey(Object key2, boolean isFirst) {
            this.deferredKey = key2;
        }

        @Override
        protected void visitEntryValue(Object value2) {
            if (Renderer.isXmlElement(value2)) {
                this.renderXmlElement((VmDynamic)value2);
            } else if (this.isXmlInline(value2)) {
                this.renderXmlInline((VmTyped)value2);
            } else {
                assert (this.deferredKey != null);
                assert (this.enclosingValue != null);
                if (VmUtils.isRenderDirective(this.deferredKey)) {
                    this.writeXmlElement(VmUtils.readTextProperty(this.deferredKey), null, value2, true, false);
                } else if (this.deferredKey instanceof String) {
                    this.writeXmlElement((String)this.deferredKey, null, value2, true, true);
                } else {
                    this.cannotRenderNonStringKey(this.deferredKey);
                }
            }
        }

        @Override
        public void visitTyped(VmTyped value2) {
            if (Renderer.isXmlComment(value2)) {
                this.renderXmlComment(value2);
            } else if (Renderer.isXmlCData(value2)) {
                this.renderXmlCData(value2);
            } else {
                super.visitTyped(value2);
            }
        }

        private static boolean isScalar(Object value2) {
            return value2 instanceof String || value2 instanceof Boolean || value2 instanceof Long || value2 instanceof Double;
        }

        private static boolean isContent(Object value2) {
            return Renderer.isScalar(value2) || Renderer.isXmlCData(value2) || Renderer.isXmlComment(value2);
        }

        private static boolean isXmlElement(Object value2) {
            return value2 instanceof VmDynamic && VmUtils.readMemberOrNull((VmDynamic)value2, Identifier.IS_XML_ELEMENT) == Boolean.TRUE;
        }

        private void renderXmlElement(VmDynamic value2) {
            assert (Renderer.isXmlElement(value2));
            Object name = VmUtils.readMember(value2, Identifier.NAME);
            if (!(name instanceof String)) {
                throw new VmExceptionBuilder().typeMismatch(value2, BaseModule.getStringClass()).build();
            }
            Object attributes = VmUtils.readMember(value2, Identifier.ATTRIBUTES);
            if (!(attributes instanceof VmMapping)) {
                throw new VmExceptionBuilder().typeMismatch(value2, BaseModule.getMappingClass()).build();
            }
            Object isBlockFormat = VmUtils.readMember(value2, Identifier.IS_BLOCK_FORMAT);
            if (!(isBlockFormat instanceof Boolean)) {
                throw new VmExceptionBuilder().typeMismatch(value2, BaseModule.getBooleanClass()).build();
            }
            this.writeXmlElement((String)name, (VmMapping)attributes, value2, (Boolean)isBlockFormat, true);
        }

        private boolean isXmlInline(Object value2) {
            return value2 instanceof VmTyped && ((VmTyped)value2).getVmClass() == XmlModule.getInlineClass();
        }

        private void renderXmlInline(VmTyped object) {
            assert (this.isXmlInline(object));
            Object value2 = VmUtils.readMember(object, Identifier.VALUE);
            this.visit(value2);
        }

        private static boolean isXmlComment(Object value2) {
            return value2 instanceof VmTyped && ((VmTyped)value2).getVmClass() == XmlModule.getCommentClass();
        }

        private void renderXmlComment(VmTyped object) {
            assert (Renderer.isXmlComment(object));
            if (RendererNodes.isBlockFormat(object)) {
                this.startNewLine();
            }
            String comment = VmUtils.readTextProperty(object);
            assert (!comment.contains("--"));
            this.builder.append("<!--").append(VmUtils.readTextProperty(object)).append("-->");
        }

        private static boolean isXmlCData(Object value2) {
            return value2 instanceof VmTyped && ((VmTyped)value2).getVmClass() == XmlModule.getCDataClass();
        }

        private void renderXmlCData(VmTyped object) {
            assert (Renderer.isXmlCData(object));
            String text = VmUtils.readTextProperty(object);
            String cdataContents = text.replace("]]>", "]]]]><![CDATA[>");
            this.builder.append("<![CDATA[").append(cdataContents).append("]]>");
        }

        private void writeXmlElement(String name, @Nullable VmMapping attributes, Object content, boolean isBlockFormat, boolean validateElementName) {
            if (isBlockFormat) {
                this.startNewLine();
            }
            if (validateElementName) {
                this.validateName(name, "element");
            }
            this.builder.append("<").append(name);
            if (attributes != null) {
                attributes.forceAndIterateMemberValues((key2, member, value2) -> {
                    this.builder.append(' ');
                    if (!(key2 instanceof String)) {
                        throw new VmExceptionBuilder().typeMismatch(name, BaseModule.getStringClass()).build();
                    }
                    this.validateName((String)key2, "attribute");
                    this.builder.append((String)key2).append("=\"");
                    if (!Renderer.isScalar(value2)) {
                        throw new VmExceptionBuilder().typeMismatch(name, BaseModule.getStringClass(), BaseModule.getBooleanClass()).build();
                    }
                    this.builder.append(stringEscaper.escape(value2.toString())).append("\"");
                    return true;
                });
            }
            this.builder.append(">");
            int prevLineNumber = this.lineNumber;
            this.increaseIndent();
            if (Renderer.isXmlElement(content)) {
                ((VmDynamic)content).forceAndIterateMemberValues((key2, member, value2) -> {
                    if (member.isElement()) {
                        this.doVisitElement(value2);
                    }
                    return true;
                });
            } else {
                this.visit(content);
            }
            this.decreaseIndent();
            if (prevLineNumber < this.lineNumber) {
                this.startNewLine();
            }
            this.builder.append("</").append(name).append(">");
        }

        private void validateName(String name, String kind) {
            if (this.validator.isValidName(name)) {
                return;
            }
            throw new VmExceptionBuilder().evalError("invalidXmlName", this.version, kind, name).build();
        }

        private void startNewLine() {
            if (this.builder.length() == 0) {
                return;
            }
            ++this.lineNumber;
            this.builder.append('\n').append((CharSequence)this.currIndent);
        }
    }

    public static abstract class renderValue
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            RendererNodes.createRenderer(self, builder).renderValue(value2);
            return builder.toString();
        }
    }

    public static abstract class renderDocument
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            RendererNodes.createRenderer(self, builder).renderDocument(value2);
            return builder.toString();
        }
    }
}

