/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.reflect;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import org.pkl.core.ast.PklNode;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.MirrorFactories;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.util.Pair;

public final class DeclaredTypeNodes {
    private static final Identifier REFERENT = Identifier.get("referent");

    private DeclaredTypeNodes() {
    }

    private static void checkTypeArgumentCount(VmTyped referent, int actualCount, PklNode node) {
        int typeParameterCount;
        Object extraStorage = referent.getExtraStorage();
        int n = typeParameterCount = extraStorage instanceof VmClass ? ((VmClass)extraStorage).getTypeParameterCount() : ((VmTypeAlias)extraStorage).getTypeParameterCount();
        if (typeParameterCount != actualCount) {
            throw new VmExceptionBuilder().evalError("wrongTypeArgumentCount", typeParameterCount, actualCount).withLocation(node).build();
        }
    }

    public static abstract class withTypeArguments
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self, VmList typeArguments) {
            VmTyped referent = (VmTyped)VmUtils.readMember(self, REFERENT);
            DeclaredTypeNodes.checkTypeArgumentCount(referent, typeArguments.getLength(), this);
            return MirrorFactories.declaredTypeFactory.create(Pair.of(referent, typeArguments));
        }
    }

    public static abstract class withTypeArgument
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmTyped eval(VmTyped self, VmTyped typeArgument) {
            VmTyped referent = (VmTyped)VmUtils.readMember(self, REFERENT);
            DeclaredTypeNodes.checkTypeArgumentCount(referent, 1, this);
            return MirrorFactories.declaredTypeFactory.create(Pair.of(referent, VmList.of(typeArgument)));
        }
    }
}

