/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import java.text.DecimalFormat;
import org.pkl.core.DataSizeUnit;
import org.pkl.core.DurationUnit;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmSafeMath;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;

public final class IntNodes {
    private IntNodes() {
    }

    public static abstract class toChar
    extends ExternalMethod0Node {
        @Specialization
        protected String eval(long self) {
            int codePoint = (int)self;
            if ((long)codePoint == self && Character.isValidCodePoint(codePoint)) {
                return Character.toString(codePoint);
            }
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("invalidCodePoint", self).build();
        }
    }

    public static abstract class isBetween
    extends ExternalMethod2Node {
        @Specialization
        protected boolean evalIntInt(long self, long start2, long inclusiveEnd) {
            return self >= start2 && self <= inclusiveEnd;
        }

        @Specialization
        protected boolean evalIntFloat(long self, long start2, double inclusiveEnd) {
            return self >= start2 && (double)self <= inclusiveEnd;
        }

        @Specialization
        protected boolean evalFloatInt(long self, double start2, long inclusiveEnd) {
            return (double)self >= start2 && self <= inclusiveEnd;
        }

        @Specialization
        protected boolean evalFloatFloat(long self, double start2, double inclusiveEnd) {
            return (double)self >= start2 && (double)self <= inclusiveEnd;
        }
    }

    public static abstract class isNonZero
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(long self) {
            return self != 0L;
        }
    }

    public static abstract class isOdd
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(long self) {
            return (self & 1L) != 0L;
        }
    }

    public static abstract class isEven
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(long self) {
            return (self & 1L) == 0L;
        }
    }

    public static abstract class isNaN
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(long self) {
            return false;
        }
    }

    public static abstract class isInfinite
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(long self) {
            return false;
        }
    }

    public static abstract class isFinite
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(long self) {
            return true;
        }
    }

    public static abstract class isPositive
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(long self) {
            return self >= 0L;
        }
    }

    public static abstract class inv
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(long self) {
            return self ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public static abstract class xor
    extends ExternalMethod1Node {
        @Specialization
        protected long eval(long self, long n) {
            return self ^ n;
        }
    }

    public static abstract class or
    extends ExternalMethod1Node {
        @Specialization
        protected long eval(long self, long n) {
            return self | n;
        }
    }

    public static abstract class and
    extends ExternalMethod1Node {
        @Specialization
        protected long eval(long self, long n) {
            return self & n;
        }
    }

    public static abstract class ushr
    extends ExternalMethod1Node {
        @Specialization
        protected long eval(long self, long n) {
            return self >>> (int)n;
        }
    }

    public static abstract class shr
    extends ExternalMethod1Node {
        @Specialization
        protected long eval(long self, long n) {
            return self >> (int)n;
        }
    }

    public static abstract class shl
    extends ExternalMethod1Node {
        @Specialization
        protected long eval(long self, long n) {
            return self << (int)n;
        }
    }

    public static abstract class toDataSize
    extends ExternalMethod1Node {
        @Specialization
        protected VmDataSize eval(long self, String str) {
            DataSizeUnit unit2 = DataSizeUnit.parse(str);
            assert (unit2 != null);
            return new VmDataSize(self, unit2);
        }
    }

    public static abstract class toDuration
    extends ExternalMethod1Node {
        @Specialization
        protected VmDuration eval(long self, String str) {
            DurationUnit unit2 = DurationUnit.parse(str);
            assert (unit2 != null);
            return new VmDuration(self, unit2);
        }
    }

    public static abstract class toFixed
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(long self, long fractionDigits) {
            assert (fractionDigits >= 0L && fractionDigits <= 20L);
            DecimalFormat format = VmUtils.createDecimalFormat((int)fractionDigits);
            return format.format(self);
        }
    }

    public static abstract class toString
    extends ExternalMethod0Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(long self) {
            return Long.toString(self);
        }
    }

    public strictfp static abstract class toFloat
    extends ExternalMethod0Node {
        @Specialization
        protected double eval(long self) {
            return self;
        }
    }

    public static abstract class toInt
    extends ExternalMethod0Node {
        @Specialization
        protected long eval(long self) {
            return self;
        }
    }

    public static abstract class truncate
    extends ExternalMethod0Node {
        @Specialization
        protected long eval(long self) {
            return self;
        }
    }

    public static abstract class round
    extends ExternalMethod0Node {
        @Specialization
        protected long eval(long self) {
            return self;
        }
    }

    public static abstract class toRadixString
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(long self, long radix) {
            return (self < 0L ? "-" : "") + Long.toString(Math.abs(self), (int)radix);
        }
    }

    public static abstract class floor
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(long self) {
            return self;
        }
    }

    public static abstract class ceil
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(long self) {
            return self;
        }
    }

    public static abstract class abs
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(long self) {
            return VmSafeMath.abs(self);
        }
    }

    public static abstract class sign
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(long self) {
            return Long.signum(self);
        }
    }

    public static abstract class pib
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(long self) {
            return new VmDataSize(self, DataSizeUnit.PEBIBYTES);
        }
    }

    public static abstract class pb
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(long self) {
            return new VmDataSize(self, DataSizeUnit.PETABYTES);
        }
    }

    public static abstract class tib
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(long self) {
            return new VmDataSize(self, DataSizeUnit.TEBIBYTES);
        }
    }

    public static abstract class tb
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(long self) {
            return new VmDataSize(self, DataSizeUnit.TERABYTES);
        }
    }

    public static abstract class gib
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(long self) {
            return new VmDataSize(self, DataSizeUnit.GIBIBYTES);
        }
    }

    public static abstract class gb
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(long self) {
            return new VmDataSize(self, DataSizeUnit.GIGABYTES);
        }
    }

    public static abstract class mib
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(long self) {
            return new VmDataSize(self, DataSizeUnit.MEBIBYTES);
        }
    }

    public static abstract class mb
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(long self) {
            return new VmDataSize(self, DataSizeUnit.MEGABYTES);
        }
    }

    public static abstract class kib
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(long self) {
            return new VmDataSize(self, DataSizeUnit.KIBIBYTES);
        }
    }

    public static abstract class kb
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(long self) {
            return new VmDataSize(self, DataSizeUnit.KILOBYTES);
        }
    }

    public static abstract class b
    extends ExternalPropertyNode {
        @Specialization
        protected VmDataSize eval(long self) {
            return new VmDataSize(self, DataSizeUnit.BYTES);
        }
    }

    public static abstract class d
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(long self) {
            return new VmDuration(self, DurationUnit.DAYS);
        }
    }

    public static abstract class h
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(long self) {
            return new VmDuration(self, DurationUnit.HOURS);
        }
    }

    public static abstract class min
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(long self) {
            return new VmDuration(self, DurationUnit.MINUTES);
        }
    }

    public static abstract class s
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(long self) {
            return new VmDuration(self, DurationUnit.SECONDS);
        }
    }

    public static abstract class ms
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(long self) {
            return new VmDuration(self, DurationUnit.MILLIS);
        }
    }

    public static abstract class us
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(long self) {
            return new VmDuration(self, DurationUnit.MICROS);
        }
    }

    public static abstract class ns
    extends ExternalPropertyNode {
        @Specialization
        protected VmDuration eval(long self) {
            return new VmDuration(self, DurationUnit.NANOS);
        }
    }
}

