/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.settings;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.regex.Pattern;
import org.pkl.core.Evaluator;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.ModuleSource;
import org.pkl.core.PModule;
import org.pkl.core.PObject;
import org.pkl.core.SecurityManagers;
import org.pkl.core.StackFrameTransformers;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.resource.ResourceReaders;
import org.pkl.core.runtime.VmEvalException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public final class PklSettings {
    private static final List<Pattern> ALLOWED_MODULES = List.of(Pattern.compile("pkl:"), Pattern.compile("file:"));
    private static final List<Pattern> ALLOWED_RESOURCES = List.of(Pattern.compile("env:"), Pattern.compile("file:"));
    private final Editor editor;

    public PklSettings(Editor editor) {
        this.editor = editor;
    }

    public static PklSettings loadFromPklHomeDir() throws VmEvalException {
        return PklSettings.loadFromPklHomeDir(IoUtils.getPklHomeDir());
    }

    static PklSettings loadFromPklHomeDir(Path pklHomeDir) throws VmEvalException {
        Path path = pklHomeDir.resolve("settings.pkl");
        return Files.exists(path, new LinkOption[0]) ? PklSettings.load(ModuleSource.path(path)) : new PklSettings(Editor.SYSTEM);
    }

    public static PklSettings load(ModuleSource moduleSource) throws VmEvalException {
        try (Evaluator evaluator = EvaluatorBuilder.unconfigured().setSecurityManager(SecurityManagers.standard(ALLOWED_MODULES, ALLOWED_RESOURCES, SecurityManagers.defaultTrustLevels, null)).setStackFrameTransformer(StackFrameTransformers.defaultTransformer).addModuleKeyFactory(ModuleKeyFactories.standardLibrary).addModuleKeyFactory(ModuleKeyFactories.file).addResourceReader(ResourceReaders.environmentVariable()).addEnvironmentVariables(System.getenv()).build();){
            PModule module = evaluator.evaluate(moduleSource);
            PklSettings pklSettings = PklSettings.parseSettings(module, moduleSource);
            return pklSettings;
        }
    }

    private static PklSettings parseSettings(PModule module, ModuleSource location) throws VmEvalException {
        Object editor = module.getPropertyOrNull("editor");
        if (!(editor instanceof PObject)) {
            throw new VmExceptionBuilder().evalError("invalidSettingsFile", location.getUri()).build();
        }
        Object urlScheme = ((PObject)editor).getPropertyOrNull("urlScheme");
        if (!(urlScheme instanceof String)) {
            throw new VmExceptionBuilder().evalError("invalidSettingsFile", location.getUri()).build();
        }
        return new PklSettings(new Editor((String)urlScheme));
    }

    public Editor getEditor() {
        return this.editor;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PklSettings that = (PklSettings)o;
        return this.editor.equals(that.editor);
    }

    public int hashCode() {
        return this.editor.hashCode();
    }

    public String toString() {
        return "PklSettings{editor=" + this.editor + "}";
    }

    public static final class Editor {
        private final String urlScheme;
        public static final Editor SYSTEM = new Editor("%{url}, line %{line}");
        public static final Editor IDEA = new Editor("idea://open?file=%{path}&line=%{line}");
        public static final Editor TEXT_MATE = new Editor("txmt://open?url=%{url}&line=%{line}&column=%{column}");
        public static final Editor SUBLIME = new Editor("subl://open?url=%{url}&line=%{line}&column=%{column}");
        public static final Editor ATOM = new Editor("atom://open?url=%{url}&line=%{line}&column=%{column}");
        public static final Editor VS_CODE = new Editor("vscode://file/%{path}:%{line}:%{column}");

        public Editor(String urlScheme) {
            this.urlScheme = urlScheme;
        }

        public String getUrlScheme() {
            return this.urlScheme;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Editor editor = (Editor)o;
            return this.urlScheme.equals(editor.urlScheme);
        }

        public int hashCode() {
            return this.urlScheme.hashCode();
        }

        public String toString() {
            return "Editor{urlScheme='" + this.urlScheme + "'}";
        }
    }
}

