/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.pkl.core.Release;
import org.pkl.core.StackFrame;
import org.pkl.core.runtime.StackTraceGenerator;
import org.pkl.core.runtime.StackTraceRenderer;
import org.pkl.core.runtime.VmBugException;
import org.pkl.core.runtime.VmException;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.StringBuilderWriter;

public class VmExceptionRenderer {
    private final @Nullable StackTraceRenderer stackTraceRenderer;

    public VmExceptionRenderer(@Nullable StackTraceRenderer stackTraceRenderer) {
        this.stackTraceRenderer = stackTraceRenderer;
    }

    @CompilerDirectives.TruffleBoundary
    public String render(VmException exception) {
        StringBuilder builder = new StringBuilder();
        this.render(exception, builder);
        return builder.toString();
    }

    private void render(VmException exception, StringBuilder builder) {
        if (exception instanceof VmBugException) {
            this.renderBugException((VmBugException)exception, builder);
        } else {
            this.renderException(exception, builder);
        }
    }

    private void renderBugException(VmBugException exception, StringBuilder builder) {
        Object exceptionToReport = exception.getCause() != null ? exception.getCause() : exception;
        builder.append("An unexpected error has occurred. Would you mind filing a bug report?\n").append("Cmd+Double-click the link below to open an issue.\n").append("Please copy and paste the entire error output into the issue's description, provided you can share it.\n\n").append("https://github.com/apple/pkl/issues/new\n\n");
        builder.append(URLEncoder.encode(((Throwable)exceptionToReport).toString(), StandardCharsets.UTF_8).replaceAll("\\+", "%20"));
        builder.append("\n\n");
        this.renderException(exception, builder);
        builder.append('\n').append(Release.current().versionInfo()).append("\n\n");
        ((Throwable)exceptionToReport).printStackTrace(new PrintWriter(new StringBuilderWriter(builder)));
    }

    private void renderException(VmException exception, StringBuilder builder) {
        List<StackFrame> frames;
        Throwable cause;
        String causeMessage;
        String message;
        String header = "\u2013\u2013 Pkl Error \u2013\u2013";
        String hint = exception.getHint();
        if (exception.isExternalMessage()) {
            String totalMessage = ErrorMessages.create(exception.getMessage(), exception.getMessageArguments());
            int index = totalMessage.indexOf("\n\n");
            if (index != -1) {
                message = totalMessage.substring(0, index);
                hint = totalMessage.substring(index + 2);
            } else {
                message = totalMessage;
            }
        } else {
            message = exception.getMessage() != null && exception.getMessageArguments().length != 0 ? String.format(exception.getMessage(), exception.getMessageArguments()) : exception.getMessage();
        }
        builder.append(header).append('\n').append(message).append('\n');
        if (exception.getCause() != null && (causeMessage = (cause = exception.getCause()).getMessage()) != null && !causeMessage.equals(message)) {
            builder.append(cause.getClass().getSimpleName()).append(": ").append(causeMessage).append('\n');
        }
        int maxNameLength = exception.getProgramValues().stream().mapToInt(v -> v.name.length()).max().orElse(0);
        for (VmException.ProgramValue value2 : exception.getProgramValues()) {
            builder.append(value2.name);
            builder.append(" ".repeat(Math.max(0, maxNameLength - value2.name.length())));
            builder.append(": ");
            builder.append(value2);
            builder.append('\n');
        }
        if (this.stackTraceRenderer != null && !(frames = StackTraceGenerator.capture(exception)).isEmpty()) {
            builder.append('\n');
            this.stackTraceRenderer.render(frames, hint, builder);
        }
    }
}

