/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.List;
import org.pkl.core.PklBugException;
import org.pkl.core.PklException;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.runtime.StackTraceRenderer;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionRenderer;
import org.pkl.core.util.Nullable;

public final class VmBugException
extends VmException {
    public VmBugException(String message, @Nullable Throwable cause, boolean isExternalMessage, Object[] messageArguments, List<VmException.ProgramValue> programValues, @Nullable Node location, @Nullable SourceSection sourceSection, @Nullable String memberName, @Nullable String hint) {
        super(message, cause, isExternalMessage, messageArguments, programValues, location, sourceSection, memberName, hint);
    }

    @CompilerDirectives.TruffleBoundary
    public String getLocalizedMessage() {
        return String.format(this.getMessage(), this.getMessageArguments());
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PklException toPklException(StackFrameTransformer transformer) {
        VmExceptionRenderer renderer = new VmExceptionRenderer(new StackTraceRenderer(transformer));
        String rendered = renderer.render(this);
        return new PklBugException(rendered, (Throwable)((Object)this));
    }
}

