/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pkl.core.PklException;

public final class TestResults {
    private final String module;
    private final String displayUri;
    private final List<TestResult> results = new ArrayList<TestResult>();
    private String err = "";

    public TestResults(String module, String displayUri) {
        this.module = module;
        this.displayUri = displayUri;
    }

    public String getModuleName() {
        return this.module;
    }

    public String getDisplayUri() {
        return this.displayUri;
    }

    public List<TestResult> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public TestResult newResult(String name) {
        TestResult result = new TestResult(name);
        this.results.add(result);
        return result;
    }

    public void newResult(String name, Failure failure) {
        TestResult result = new TestResult(name);
        result.addFailure(failure);
        this.results.add(result);
    }

    public int totalTests() {
        return this.results.size();
    }

    public int totalFailures() {
        int total = 0;
        for (TestResult res : this.results) {
            total += res.getFailures().size();
        }
        return total;
    }

    public boolean failed() {
        for (TestResult res : this.results) {
            if (!res.isFailure()) continue;
            return true;
        }
        return false;
    }

    public String getErr() {
        return this.err;
    }

    public void setErr(String err) {
        this.err = err;
    }

    public static class Error {
        private final String message;
        private final PklException exception;

        public Error(String message, PklException exception) {
            this.message = message;
            this.exception = exception;
        }

        public String getMessage() {
            return this.message;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class Failure {
        private final String kind;
        private final String rendered;

        private Failure(String kind, String rendered) {
            this.kind = kind;
            this.rendered = rendered;
        }

        public String getKind() {
            return this.kind;
        }

        public String getRendered() {
            return this.rendered;
        }

        public static Failure buildFactFailure(SourceSection sourceSection, String description) {
            return new Failure("Fact Failure", sourceSection.getCharacters() + " \u274c (" + description + ")");
        }

        public static Failure buildExampleLengthMismatchFailure(String location, String property, int expectedLength, int actualLength) {
            String builder = "(" + location + ")\nOutput mismatch: Expected \"" + property + "\" to contain " + expectedLength + " examples, but found " + actualLength;
            return new Failure("Output Mismatch (Length)", builder);
        }

        public static Failure buildExamplePropertyMismatchFailure(String location, String property, boolean isMissingInExpected) {
            StringBuilder builder = new StringBuilder();
            builder.append("(").append(location).append(")\n").append("Output mismatch: \"").append(property);
            if (isMissingInExpected) {
                builder.append("\" exists in actual but not in expected output");
            } else {
                builder.append("\" exists in expected but not in actual output");
            }
            return new Failure("Output Mismatch", builder.toString());
        }

        public static Failure buildExampleFailure(String location, String expectedLocation, String expectedValue, String actualLocation, String actualValue) {
            String builder = "(" + location + ")\nExpected: (" + expectedLocation + ")\n" + expectedValue + "\nActual: (" + actualLocation + ")\n" + actualValue;
            return new Failure("Example Failure", builder);
        }
    }

    public static class TestResult {
        private final String name;
        private final List<Failure> failures = new ArrayList<Failure>();
        private final List<Error> errors = new ArrayList<Error>();
        private boolean isExampleWritten = false;

        public TestResult(String name) {
            this.name = name;
        }

        public boolean isSuccess() {
            return this.failures.isEmpty() && this.errors.isEmpty();
        }

        boolean isFailure() {
            return !this.isSuccess();
        }

        public String getName() {
            return this.name;
        }

        public boolean isExampleWritten() {
            return this.isExampleWritten;
        }

        public void setExampleWritten(boolean exampleWritten) {
            this.isExampleWritten = exampleWritten;
        }

        public List<Failure> getFailures() {
            return Collections.unmodifiableList(this.failures);
        }

        public void addFailure(Failure description) {
            this.failures.add(description);
        }

        public List<Error> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }

        public void addError(Error err) {
            this.errors.add(err);
        }
    }
}

