/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.pkl.core.StackFrame;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;

public class StackTraceRenderer {
    private final Function<StackFrame, StackFrame> frameTransformer;

    public StackTraceRenderer(Function<StackFrame, StackFrame> frameTransformer) {
        this.frameTransformer = frameTransformer;
    }

    public void render(List<StackFrame> frames, @Nullable String hint, StringBuilder builder) {
        List<Object> compressed = StackTraceRenderer.compressFrames(frames);
        this.doRender(compressed, hint, builder, "", true);
    }

    void doRender(List<Object> frames, @Nullable String hint, StringBuilder builder, String leftMargin, boolean isFirstElement) {
        for (Object frame : frames) {
            if (frame instanceof StackFrameLoop) {
                StackFrameLoop loop = (StackFrameLoop)frame;
                if (loop.count == 1) {
                    this.doRender(loop.frames, null, builder, leftMargin, isFirstElement);
                } else {
                    if (!isFirstElement) {
                        builder.append(leftMargin).append("\n");
                    }
                    builder.append(leftMargin).append("\u250c\u2500 ").append(loop.count).append(" repetitions of:\n");
                    String newLeftMargin = leftMargin + "\u2502 ";
                    this.doRender(loop.frames, null, builder, newLeftMargin, isFirstElement);
                    if (isFirstElement) {
                        this.renderHint(hint, builder, newLeftMargin);
                        isFirstElement = false;
                    }
                    builder.append(leftMargin).append("\u2514\u2500\n");
                }
            } else {
                if (!isFirstElement) {
                    builder.append(leftMargin).append('\n');
                }
                this.renderFrame((StackFrame)frame, builder, leftMargin);
            }
            if (!isFirstElement) continue;
            this.renderHint(hint, builder, leftMargin);
            isFirstElement = false;
        }
    }

    private void renderFrame(StackFrame frame, StringBuilder builder, String leftMargin) {
        StackFrame transformed = this.frameTransformer.apply(frame);
        this.renderSourceLine(transformed, builder, leftMargin);
        this.renderSourceLocation(transformed, builder, leftMargin);
    }

    private void renderHint(@Nullable String hint, StringBuilder builder, String leftMargin) {
        if (hint == null || hint.isEmpty()) {
            return;
        }
        builder.append('\n');
        builder.append(leftMargin);
        builder.append(hint);
        builder.append('\n');
    }

    private void renderSourceLine(StackFrame frame, StringBuilder builder, String leftMargin) {
        int i;
        String originalSourceLine = frame.getSourceLines().get(0);
        int leadingWhitespace = VmUtils.countLeadingWhitespace(originalSourceLine);
        String sourceLine = originalSourceLine.strip();
        int startColumn = frame.getStartColumn() - leadingWhitespace;
        int endColumn = frame.getStartLine() == frame.getEndLine() ? frame.getEndColumn() - leadingWhitespace : sourceLine.length();
        String prefix = frame.getStartLine() + " | ";
        builder.append(leftMargin).append(prefix).append(sourceLine).append('\n');
        builder.append(leftMargin);
        for (i = 1; i < prefix.length() + startColumn; ++i) {
            builder.append(' ');
        }
        for (i = startColumn; i <= endColumn; ++i) {
            builder.append('^');
        }
        builder.append('\n');
    }

    private void renderSourceLocation(StackFrame frame, StringBuilder builder, String leftMargin) {
        builder.append(leftMargin).append("at ");
        if (frame.getMemberName() != null) {
            builder.append(frame.getMemberName());
        } else {
            builder.append("<unknown>");
        }
        builder.append(" (").append(frame.getModuleUri()).append(')').append('\n');
    }

    static List<Object> compressFrames(List<StackFrame> frames) {
        return StackTraceRenderer.doCompressFrames(frames, new int[frames.size()], new ArrayList<Object>(), 0, frames.size());
    }

    private static List<Object> doCompressFrames(List<StackFrame> frames, int[] lpps, List<Object> result, int beginning, int ending) {
        int i;
        int framesLastIndex = frames.size() - 1;
        int totalSize = ending - beginning;
        int maxLength = -1;
        int patternStart = -2;
        int patternWidth = -2;
        int matchEnd = -2;
        block0: for (i = beginning; i < ending; ++i) {
            int best = i;
            int len = 0;
            lpps[i] = 0;
            int j = i + 1;
            while (j < ending) {
                StackFrame frame2;
                StackFrame frame1 = frames.get(framesLastIndex - j);
                boolean match = frame1.equals(frame2 = frames.get(framesLastIndex - (len + i)));
                if (!match && len != 0) {
                    len = lpps[len - 1];
                    continue;
                }
                lpps[j] = len += match ? 1 : 0;
                if (len > lpps[best]) {
                    best = j;
                } else if (len > 0 && len == lpps[j - 1]) continue block0;
                ++j;
            }
            int length2 = best - i + 1;
            if (length2 > 1 && maxLength < length2) {
                maxLength = length2;
                matchEnd = best;
                patternStart = i;
            }
            if (maxLength > ending - i || maxLength * 2 > totalSize) break;
        }
        if (maxLength > 1) {
            patternWidth = matchEnd - lpps[matchEnd] - patternStart + 1;
            StackTraceRenderer.doCompressFrames(frames, lpps, result, matchEnd + 1, ending);
            result.add(new StackFrameLoop(StackTraceRenderer.doCompressFrames(frames, lpps, new ArrayList<Object>(), patternStart, patternStart + patternWidth), maxLength / patternWidth));
            StackTraceRenderer.doCompressFrames(frames, lpps, result, beginning, patternStart);
        } else {
            for (i = ending - 1; i >= beginning; --i) {
                result.add(frames.get(framesLastIndex - i));
            }
        }
        return result;
    }

    static class StackFrameLoop {
        final List<Object> frames;
        final int count;

        StackFrameLoop(List<Object> frames, int count2) {
            this.count = count2;
            this.frames = frames;
        }
    }
}

