/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.resource.Resource;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.stdlib.VmObjectFactory;
import org.pkl.core.util.GlobResolver;

public final class ResourceManager {
    private final Map<String, ResourceReader> resourceReaders = new HashMap<String, ResourceReader>();
    private final SecurityManager securityManager;
    private final VmObjectFactory<Resource> resourceFactory;
    private final Map<URI, Optional<Object>> resources = new HashMap<URI, Optional<Object>>();
    private final Map<URI, List<GlobResolver.ResolvedGlobElement>> globExpressions = new HashMap<URI, List<GlobResolver.ResolvedGlobElement>>();

    public ResourceManager(SecurityManager securityManager, Collection<ResourceReader> readers) {
        this.securityManager = securityManager;
        for (ResourceReader reader : readers) {
            this.resourceReaders.put(reader.getUriScheme(), reader);
        }
        this.resourceFactory = new VmObjectFactory<Resource>(BaseModule::getResourceClass).addProperty("uri", resource -> resource.getUri().toString()).addProperty("text", Resource::getText).addProperty("base64", Resource::getBase64);
    }

    @CompilerDirectives.TruffleBoundary
    public List<GlobResolver.ResolvedGlobElement> resolveGlob(URI globUri, URI enclosingUri, ModuleKey enclosingModuleKey, Node readNode, String globExpression) {
        return this.globExpressions.computeIfAbsent(globUri.normalize(), uri -> {
            URI resolvedUri;
            String scheme = uri.getScheme();
            try {
                resolvedUri = enclosingModuleKey.resolveUri(globUri);
            }
            catch (IOException | SecurityManagerException e2) {
                throw new VmExceptionBuilder().withLocation(readNode).withCause(e2).build();
            }
            try {
                ResourceReader reader = this.resourceReaders.get(resolvedUri.getScheme());
                if (reader == null) {
                    throw new VmExceptionBuilder().withLocation(readNode).evalError("noResourceReaderRegistered", scheme).build();
                }
                if (!reader.isGlobbable()) {
                    throw new VmExceptionBuilder().evalError("cannotGlobUri", uri, scheme).withLocation(readNode).build();
                }
                SecurityManager securityManager = VmContext.get(readNode).getSecurityManager();
                return GlobResolver.resolveGlob(securityManager, reader, enclosingModuleKey, enclosingUri, globExpression);
            }
            catch (GlobResolver.InvalidGlobPatternException e3) {
                throw new VmExceptionBuilder().evalError("invalidGlobPattern", globExpression).withHint(e3.getMessage()).withLocation(readNode).build();
            }
            catch (SecurityManagerException e4) {
                throw new VmExceptionBuilder().withCause(e4).withLocation(readNode).build();
            }
            catch (IOException e5) {
                throw new VmExceptionBuilder().evalError("ioErrorResolvingGlob", globExpression).withCause(e5).withLocation(readNode).build();
            }
        });
    }

    @CompilerDirectives.TruffleBoundary
    public Optional<Object> read(URI resourceUri, Node readNode) {
        return this.resources.computeIfAbsent(resourceUri.normalize(), uri -> {
            Optional<Object> resource;
            try {
                this.securityManager.checkReadResource((URI)uri);
            }
            catch (SecurityManagerException e2) {
                throw new VmExceptionBuilder().withCause(e2).withLocation(readNode).build();
            }
            ResourceReader reader = this.resourceReaders.get(uri.getScheme());
            if (reader == null) {
                throw new VmExceptionBuilder().withLocation(readNode).evalError("noResourceReaderRegistered", resourceUri.getScheme()).build();
            }
            try {
                resource = reader.read((URI)uri);
            }
            catch (IOException e3) {
                throw new VmExceptionBuilder().evalError("ioErrorReadingResource", uri).withCause(e3).withLocation(readNode).build();
            }
            catch (URISyntaxException e4) {
                throw new VmExceptionBuilder().evalError("invalidResourceUri", resourceUri).withHint(e4.getReason()).withLocation(readNode).build();
            }
            catch (SecurityManagerException | PackageLoadError e5) {
                throw new VmExceptionBuilder().withCause(e5).withLocation(readNode).build();
            }
            if (resource.isEmpty()) {
                return resource;
            }
            Object res = resource.get();
            if (res instanceof String) {
                return resource;
            }
            if (res instanceof Resource) {
                return Optional.of(this.resourceFactory.create((Resource)res));
            }
            throw new VmExceptionBuilder().evalError("unsupportedResourceType", reader.getClass().getName(), res.getClass()).withLocation(readNode).build();
        });
    }
}

