/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.type.ResolveDeclaredTypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;

public final class ResolveSimpleDeclaredTypeNode
extends ResolveDeclaredTypeNode {
    private final Identifier typeName;
    private final boolean isBaseModule;

    public ResolveSimpleDeclaredTypeNode(SourceSection sourceSection, Identifier typeName, boolean isBaseModule) {
        super(sourceSection);
        this.typeName = typeName;
        this.isBaseModule = isBaseModule;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        Identifier localTypeName = this.typeName.toLocalProperty();
        VmTyped enclosingModule = this.getEnclosingModule(VmUtils.getOwner((Frame)frame));
        Object result = this.getType(enclosingModule, localTypeName, this.sourceSection);
        if (result != null) {
            return result;
        }
        VmTyped currModule = enclosingModule;
        do {
            if ((result = this.getType(currModule, this.typeName, this.sourceSection)) != null) {
                return result;
            }
            if (this.isBaseModule || currModule != enclosingModule || (result = this.getType(BaseModule.getModule(), this.typeName, this.sourceSection)) == null) continue;
            return result;
        } while ((currModule = currModule.getParent()) != null);
        throw this.exceptionBuilder().evalError("cannotFindSimpleType", this.typeName, enclosingModule.getModuleInfo().getModuleName()).build();
    }
}

