/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValueRenderer;

public final class TraceNode
extends ExpressionNode {
    @Node.Child
    private ExpressionNode valueNode;
    private final VmValueRenderer renderer = VmValueRenderer.singleLine(1000000);

    public TraceNode(SourceSection sourceSection, ExpressionNode valueNode) {
        super(sourceSection);
        this.valueNode = valueNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        Object value2 = this.valueNode.executeGeneric(frame);
        this.doTrace(value2, VmContext.get(this));
        return value2;
    }

    @CompilerDirectives.TruffleBoundary
    private void doTrace(Object value2, VmContext context) {
        if (value2 instanceof VmObjectLike) {
            try {
                ((VmObjectLike)value2).force(true, true);
            }
            catch (VmException vmException) {
                // empty catch block
            }
        }
        SourceSection sourceSection = this.valueNode.getSourceSection();
        String renderedValue = this.renderer.render(value2);
        String message = (sourceSection.isAvailable() ? sourceSection.getCharacters() : "<value") + " = " + renderedValue;
        context.getLogger().trace(message, VmUtils.createStackFrame(sourceSection, null));
    }
}

