/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.ast.expression.unary.UnaryExpressionNode;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public abstract class AbstractReadNode
extends UnaryExpressionNode {
    private final ModuleKey moduleKey;

    protected AbstractReadNode(SourceSection sourceSection, ModuleKey moduleKey) {
        super(sourceSection);
        this.moduleKey = moduleKey;
    }

    @CompilerDirectives.TruffleBoundary
    protected @Nullable Object doRead(String resourceUri, VmContext context, Node readNode) {
        URI resolvedUri = this.resolveResource(this.moduleKey, resourceUri);
        return context.getResourceManager().read(resolvedUri, readNode).orElse(null);
    }

    private URI resolveResource(ModuleKey moduleKey, String resourceUri) {
        URI resolvedUri;
        URI parsedUri;
        try {
            parsedUri = IoUtils.toUri(resourceUri);
        }
        catch (URISyntaxException e2) {
            throw this.exceptionBuilder().evalError("invalidResourceUri", resourceUri).withHint(e2.getReason()).build();
        }
        VmContext context = VmContext.get(this);
        try {
            resolvedUri = IoUtils.resolve(context.getSecurityManager(), moduleKey, parsedUri);
        }
        catch (FileNotFoundException e3) {
            throw this.exceptionBuilder().evalError("cannotFindResource", resourceUri).build();
        }
        catch (URISyntaxException e4) {
            throw this.exceptionBuilder().evalError("invalidResourceUri", resourceUri).withHint(e4.getReason()).build();
        }
        catch (IOException e5) {
            throw this.exceptionBuilder().evalError("ioErrorReadingResource", resourceUri).withHint(e5.getMessage()).build();
        }
        catch (SecurityManagerException | PackageLoadError e6) {
            throw this.exceptionBuilder().withCause(e6).build();
        }
        if (!resolvedUri.isAbsolute()) {
            throw this.exceptionBuilder().evalError("cannotHaveRelativeResource", moduleKey.getUri()).build();
        }
        return resolvedUri;
    }
}

