/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.literal;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.PklNode;
import org.pkl.core.ast.PklRootNode;
import org.pkl.core.ast.SimpleRootNode;
import org.pkl.core.ast.builder.SymbolTable;
import org.pkl.core.ast.expression.literal.ObjectLiteralNode;
import org.pkl.core.ast.frame.ReadFrameSlotNodeGen;
import org.pkl.core.ast.member.FunctionNode;
import org.pkl.core.ast.member.Lambda;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;

public final class AmendFunctionNode
extends PklNode {
    private final boolean isCustomThisScope;
    private final PklRootNode initialFunctionRootNode;
    @CompilerDirectives.CompilationFinal
    private int customThisSlot = -1;

    public AmendFunctionNode(ObjectLiteralNode hostNode, TypeNode[] parameterTypeNodes, FrameDescriptor hostFrameDesecriptor) {
        super(hostNode.getSourceSection());
        int i;
        int[] parameterSlots;
        this.isCustomThisScope = hostNode.isCustomThisScope;
        FrameDescriptor.Builder builder = FrameDescriptor.newBuilder();
        FrameDescriptor hostDescriptor = hostNode.parametersDescriptor;
        if (hostDescriptor != null) {
            parameterSlots = new int[hostDescriptor.getNumberOfSlots()];
            for (i = 0; i < hostDescriptor.getNumberOfSlots(); ++i) {
                int slot;
                FrameSlotKind slotKind = hostDescriptor.getSlotKind(i);
                parameterSlots[i] = slot = builder.addSlot(slotKind, hostDescriptor.getSlotName(i), null);
            }
        } else {
            parameterSlots = new int[]{};
        }
        for (i = 0; i < hostFrameDesecriptor.getNumberOfSlots(); ++i) {
            Object slotInfo = hostFrameDesecriptor.getSlotInfo(i);
            if (slotInfo == null || !slotInfo.equals(SymbolTable.FOR_GENERATOR_VARIABLE)) continue;
            builder.addSlot(hostFrameDesecriptor.getSlotKind(i), hostFrameDesecriptor.getSlotName(i), null);
        }
        int objectToAmendSlot = builder.addSlot(FrameSlotKind.Object, new Object(), null);
        FrameDescriptor frameDescriptor = builder.build();
        SimpleRootNode subsequentFunctionRootNode = new SimpleRootNode(hostNode.language, frameDescriptor, this.sourceSection, hostNode.qualifiedScopeName + ".<function>", new AmendFunctionBodyNode(this.sourceSection, hostNode.copy(ReadFrameSlotNodeGen.create(hostNode.getParentNode().getSourceSection(), objectToAmendSlot)), parameterSlots, objectToAmendSlot, null));
        if (parameterSlots.length > 0) {
            int parameterCount = hostNode.parameterTypes.length;
            this.initialFunctionRootNode = new FunctionNode(hostNode.language, frameDescriptor, new Lambda(this.sourceSection, hostNode.qualifiedScopeName + ".<function>"), parameterCount, parameterTypeNodes, null, true, new AmendFunctionBodyNode(this.sourceSection, hostNode.copy(ReadFrameSlotNodeGen.create(hostNode.getParentNode().getSourceSection(), objectToAmendSlot)), parameterSlots, objectToAmendSlot, subsequentFunctionRootNode));
        } else {
            this.initialFunctionRootNode = subsequentFunctionRootNode;
        }
    }

    public VmFunction execute(VirtualFrame frame, VmFunction functionToAmend) {
        if (this.isCustomThisScope && this.customThisSlot == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.customThisSlot = VmUtils.findAuxiliarySlot(frame, SymbolTable.CustomThisScope.FRAME_SLOT_ID);
        }
        return new VmFunction(frame.materialize(), this.isCustomThisScope ? frame.getAuxiliarySlot(this.customThisSlot) : VmUtils.getReceiver((Frame)frame), functionToAmend.getParameterCount(), this.initialFunctionRootNode, new Context(functionToAmend, null));
    }

    @CompilerDirectives.ValueType
    private static class Context {
        public final VmFunction function;
        public final @Nullable MaterializedFrame frame;

        public Context(VmFunction function, @Nullable MaterializedFrame frame) {
            this.function = function;
            this.frame = frame;
        }

        public Context setFunction(VmFunction newFunction) {
            return new Context(newFunction, this.frame);
        }

        public Context setFrame(MaterializedFrame newFrame) {
            return new Context(this.function, newFrame);
        }
    }

    private static class AmendFunctionBodyNode
    extends ExpressionNode {
        @Node.Child
        private ExpressionNode amendObjectNode;
        private final int[] parameterSlots;
        private final int valueToAmendSlot;
        private final @Nullable PklRootNode nextFunctionRootNode;
        @Node.Child
        private IndirectCallNode callNode = IndirectCallNode.create();

        public AmendFunctionBodyNode(SourceSection sourceSection, ExpressionNode amendObjectNode, int[] parameterSlots, int valueToAmendSlot, @Nullable PklRootNode nextFunctionRootNode) {
            super(sourceSection);
            this.amendObjectNode = amendObjectNode;
            this.parameterSlots = parameterSlots;
            this.valueToAmendSlot = valueToAmendSlot;
            this.nextFunctionRootNode = nextFunctionRootNode;
        }

        @Override
        @ExplodeLoop
        public Object executeGeneric(VirtualFrame frame) {
            Object[] frameArguments = frame.getArguments();
            VmFunction currentFunction = (VmFunction)VmUtils.getOwner((Frame)frame);
            Context context = (Context)currentFunction.getExtraStorage();
            if (this.nextFunctionRootNode != null) {
                context = context.setFrame(frame.materialize());
            }
            VmFunction functionToAmend = context.function;
            Object[] arguments = new Object[frameArguments.length];
            arguments[0] = functionToAmend.getThisValue();
            arguments[1] = functionToAmend;
            System.arraycopy(frameArguments, 2, arguments, 2, frameArguments.length - 2);
            Object valueToAmend = this.callNode.call((CallTarget)functionToAmend.getCallTarget(), arguments);
            if (!(valueToAmend instanceof VmFunction)) {
                MaterializedFrame materializedFrame = context.frame;
                if (materializedFrame != null) {
                    for (int slot : this.parameterSlots) {
                        frame.setObject(slot, materializedFrame.getValue(slot));
                    }
                }
                frame.setObject(this.valueToAmendSlot, valueToAmend);
                return this.amendObjectNode.executeGeneric(frame);
            }
            VmFunction newFunctionToAmend = (VmFunction)valueToAmend;
            return currentFunction.copy(newFunctionToAmend.getParameterCount(), this.nextFunctionRootNode, context.setFunction(newFunctionToAmend));
        }
    }
}

