/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast;

import java.util.EnumSet;
import java.util.Set;
import org.pkl.core.Modifier;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmSet;

public final class VmModifier {
    public static final int ABSTRACT = 1;
    public static final int OPEN = 2;
    public static final int LOCAL = 4;
    public static final int HIDDEN = 8;
    public static final int EXTERNAL = 16;
    public static final int FIXED = 32;
    public static final int CONST = 64;
    public static final int IMPORT = 128;
    public static final int CLASS = 256;
    public static final int TYPE_ALIAS = 512;
    public static final int ENTRY = 1024;
    public static final int ELEMENT = 2048;
    public static final int GLOB = 4096;
    public static final int NONE = 0;
    public static final int VALID_MODULE_MODIFIERS = 3;
    public static final int VALID_AMENDING_MODULE_MODIFIERS = 0;
    public static final int VALID_CLASS_MODIFIERS = 23;
    public static final int VALID_TYPE_ALIAS_MODIFIERS = 20;
    public static final int VALID_METHOD_MODIFIERS = 85;
    public static final int VALID_PROPERTY_MODIFIERS = 125;
    public static final int VALID_OBJECT_MEMBER_MODIFIERS = 4;

    public static boolean isLocal(int modifiers) {
        return (modifiers & 4) != 0;
    }

    public static boolean isAbstract(int modifiers) {
        return (modifiers & 1) != 0;
    }

    public static boolean isFixed(int modifiers) {
        return (modifiers & 0x20) != 0;
    }

    public static boolean isOpen(int modifiers) {
        return (modifiers & 2) != 0;
    }

    public static boolean isHidden(int modifiers) {
        return (modifiers & 8) != 0;
    }

    public static boolean isExternal(int modifiers) {
        return (modifiers & 0x10) != 0;
    }

    public static boolean isClass(int modifiers) {
        return (modifiers & 0x100) != 0;
    }

    public static boolean isTypeAlias(int modifiers) {
        return (modifiers & 0x200) != 0;
    }

    public static boolean isImport(int modifiers) {
        return (modifiers & 0x80) != 0;
    }

    public static boolean isGlob(int modifiers) {
        return (modifiers & 0x1000) != 0;
    }

    public static boolean isConst(int modifiers) {
        return (modifiers & 0x40) != 0;
    }

    public static boolean isElement(int modifiers) {
        return (modifiers & 0x800) != 0;
    }

    public static boolean isEntry(int modifiers) {
        return (modifiers & 0x400) != 0;
    }

    public static boolean isType(int modifiers) {
        return (modifiers & 0x380) != 0 && (modifiers & 0x1000) == 0;
    }

    public static boolean isLocalOrExternalOrHidden(int modifiers) {
        return (modifiers & 0x1C) != 0;
    }

    public static boolean isLocalOrExternalOrAbstract(int modifiers) {
        return (modifiers & 0x15) != 0;
    }

    public static boolean isConstOrFixed(int modifiers) {
        return (modifiers & 0x60) != 0;
    }

    public static Set<Modifier> export(int modifiers, boolean isClass) {
        EnumSet<Modifier> result = EnumSet.noneOf(Modifier.class);
        if (VmModifier.isAbstract(modifiers)) {
            result.add(Modifier.ABSTRACT);
        }
        if (VmModifier.isOpen(modifiers)) {
            result.add(Modifier.OPEN);
        }
        if (VmModifier.isHidden(modifiers)) {
            result.add(Modifier.HIDDEN);
        }
        if (VmModifier.isExternal(modifiers) && isClass) {
            result.add(Modifier.EXTERNAL);
        }
        return result;
    }

    public static String toString(int modifier) {
        switch (modifier) {
            case 1: {
                return "abstract";
            }
            case 2: {
                return "open";
            }
            case 4: {
                return "local";
            }
            case 8: {
                return "hidden";
            }
            case 16: {
                return "external";
            }
        }
        throw new VmExceptionBuilder().bug("Cannot convert internal modifier `%s` to a string.", VmModifier.toString(modifier)).build();
    }

    public static VmSet getMirrors(int modifiers, boolean isClass) {
        VmCollection.Builder<VmSet> builder = VmSet.EMPTY.builder();
        if (VmModifier.isAbstract(modifiers)) {
            builder.add(VmModifier.toString(1));
        }
        if (VmModifier.isOpen(modifiers)) {
            builder.add(VmModifier.toString(2));
        }
        if (VmModifier.isHidden(modifiers)) {
            builder.add(VmModifier.toString(8));
        }
        if (VmModifier.isExternal(modifiers) && isClass) {
            builder.add(VmModifier.toString(16));
        }
        return builder.build();
    }

    public static boolean isClosed(int modifiers) {
        return (modifiers & 3) == 0;
    }

    public static boolean isInstantiable(int modifiers) {
        return (modifiers & 0x11) == 0;
    }
}

