/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.pkl.core.DataSize;
import org.pkl.core.Duration;
import org.pkl.core.PClass;
import org.pkl.core.PModule;
import org.pkl.core.PObject;
import org.pkl.core.Pair;
import org.pkl.core.TypeAlias;
import org.pkl.core.Value;

public interface ValueConverter<T> {
    public T convertNull();

    public T convertString(String var1);

    public T convertBoolean(Boolean var1);

    public T convertInt(Long var1);

    public T convertFloat(Double var1);

    public T convertDuration(Duration var1);

    public T convertDataSize(DataSize var1);

    public T convertPair(Pair<?, ?> var1);

    public T convertList(List<?> var1);

    public T convertSet(Set<?> var1);

    public T convertMap(Map<?, ?> var1);

    public T convertObject(PObject var1);

    public T convertModule(PModule var1);

    public T convertClass(PClass var1);

    public T convertTypeAlias(TypeAlias var1);

    public T convertRegex(Pattern var1);

    default public T convert(Object value2) {
        if (value2 instanceof Value) {
            return ((Value)value2).accept(this);
        }
        if (value2 instanceof String) {
            return this.convertString((String)value2);
        }
        if (value2 instanceof Boolean) {
            return this.convertBoolean((Boolean)value2);
        }
        if (value2 instanceof Long) {
            return this.convertInt((Long)value2);
        }
        if (value2 instanceof Double) {
            return this.convertFloat((Double)value2);
        }
        if (value2 instanceof List) {
            return this.convertList((List)value2);
        }
        if (value2 instanceof Set) {
            return this.convertSet((Set)value2);
        }
        if (value2 instanceof Map) {
            return this.convertMap((Map)value2);
        }
        if (value2 instanceof Pattern) {
            return this.convertRegex((Pattern)value2);
        }
        throw new IllegalArgumentException("Cannot convert value with unexpected type: " + value2);
    }
}

