/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerBuilder;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Nullable;

public final class SecurityManagers {
    public static final List<Pattern> defaultAllowedModules = List.of(Pattern.compile("repl:"), Pattern.compile("file:"), Pattern.compile("jar:file:"), Pattern.compile("modulepath:"), Pattern.compile("https:"), Pattern.compile("pkl:"), Pattern.compile("package:"), Pattern.compile("projectpackage:"));
    public static final List<Pattern> defaultAllowedResources = List.of(Pattern.compile("prop:"), Pattern.compile("env:"), Pattern.compile("file:"), Pattern.compile("modulepath:"), Pattern.compile("package:"), Pattern.compile("projectpackage:"), Pattern.compile("https:"));
    public static final Function<URI, Integer> defaultTrustLevels = SecurityManagers::getDefaultTrustLevel;
    public static final SecurityManager defaultManager = new Standard(defaultAllowedModules, defaultAllowedResources, defaultTrustLevels, null);

    private SecurityManagers() {
    }

    private static int getDefaultTrustLevel(URI uri) {
        switch (uri.getScheme()) {
            case "repl": {
                return 40;
            }
            case "file": {
                return uri.getHost() == null ? 30 : 10;
            }
            case "jar": {
                return SecurityManagers.getDefaultTrustLevel(URI.create(uri.toString().substring(4)));
            }
            case "modulepath": {
                return 20;
            }
            case "pkl": {
                return 0;
            }
        }
        return 10;
    }

    public static SecurityManager standard(List<Pattern> allowedModules, List<Pattern> allowedResources, Function<URI, Integer> trustLevels, @Nullable Path rootDir) {
        return new Standard(allowedModules, allowedResources, trustLevels, rootDir);
    }

    public static StandardBuilder standardBuilder() {
        return new StandardBuilder();
    }

    public static class StandardBuilder
    implements SecurityManagerBuilder<StandardBuilder> {
        private final List<Pattern> allowedModules = new ArrayList<Pattern>();
        private final List<Pattern> allowedResources = new ArrayList<Pattern>();
        private Path rootDir;

        private StandardBuilder() {
        }

        @Override
        public StandardBuilder addAllowedModule(Pattern pattern2) {
            this.allowedModules.add(pattern2);
            return this;
        }

        @Override
        public StandardBuilder addAllowedModules(Collection<Pattern> patterns) {
            this.allowedModules.addAll(patterns);
            return this;
        }

        @Override
        public StandardBuilder setAllowedModules(Collection<Pattern> patterns) {
            this.allowedModules.clear();
            this.allowedModules.addAll(patterns);
            return this;
        }

        @Override
        public List<Pattern> getAllowedModules() {
            return this.allowedModules;
        }

        @Override
        public StandardBuilder addAllowedResource(Pattern pattern2) {
            this.allowedResources.add(pattern2);
            return this;
        }

        @Override
        public StandardBuilder addAllowedResources(Collection<Pattern> patterns) {
            this.allowedResources.addAll(patterns);
            return this;
        }

        @Override
        public StandardBuilder setAllowedResources(Collection<Pattern> patterns) {
            this.allowedResources.clear();
            this.allowedResources.addAll(patterns);
            return this;
        }

        @Override
        public List<Pattern> getAllowedResources() {
            return this.allowedResources;
        }

        @Override
        public StandardBuilder setRootDir(@Nullable Path rootDir) {
            this.rootDir = rootDir;
            return this;
        }

        @Override
        public @Nullable Path getRootDir() {
            return this.rootDir;
        }

        @Override
        public SecurityManager build() {
            if (this.allowedResources.isEmpty() && this.allowedModules.isEmpty()) {
                throw new IllegalStateException("No security manager set.");
            }
            return new Standard(this.allowedModules, this.allowedResources, defaultTrustLevels, this.rootDir);
        }
    }

    private static class Standard
    implements SecurityManager {
        private final List<Pattern> allowedModules;
        private final List<Pattern> allowedResources;
        private final Function<URI, Integer> trustLevels;
        private final @Nullable Path rootDir;

        Standard(List<Pattern> allowedModules, List<Pattern> allowedResources, Function<URI, Integer> trustLevels, @Nullable Path rootDir) {
            this.allowedModules = allowedModules;
            this.allowedResources = allowedResources;
            this.trustLevels = trustLevels;
            this.rootDir = this.normalizePath(rootDir);
        }

        @Override
        public void checkResolveModule(URI uri) throws SecurityManagerException {
            this.checkRead(uri, this.allowedModules, "moduleNotInAllowList");
        }

        @Override
        public void checkResolveResource(URI resource) throws SecurityManagerException {
            this.checkRead(resource, this.allowedResources, "resourceNotInAllowList");
        }

        @Override
        public void checkReadResource(URI uri) throws SecurityManagerException {
            this.checkRead(uri, this.allowedResources, "resourceNotInAllowList");
        }

        @Override
        public void checkImportModule(URI importingModule, URI importedModule) throws SecurityManagerException {
            Integer importingTrustLevel = this.trustLevels.apply(importingModule);
            Integer importedTrustLevel = this.trustLevels.apply(importedModule);
            if (importingTrustLevel < importedTrustLevel) {
                String message = ErrorMessages.create("insufficientModuleTrustLevel", importedModule, importingModule);
                throw new SecurityManagerException(message);
            }
        }

        private @Nullable Path normalizePath(@Nullable Path path) {
            if (path == null) {
                return null;
            }
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    return path.toRealPath(new LinkOption[0]);
                }
                return path.toAbsolutePath();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        private void checkRead(URI uri, List<Pattern> allowedPatterns, String errorMessageKey) throws SecurityManagerException {
            for (Pattern pattern2 : allowedPatterns) {
                if (!pattern2.matcher(uri.toString()).lookingAt()) continue;
                this.checkIsUnderRootDir(uri, errorMessageKey);
                return;
            }
            String message = ErrorMessages.create(errorMessageKey, uri);
            throw new SecurityManagerException(message);
        }

        private void checkIsUnderRootDir(URI uri, String errorMessageKey) throws SecurityManagerException {
            if (!uri.isAbsolute()) {
                throw new AssertionError((Object)("Expected absolute URI but got: " + uri));
            }
            if (this.rootDir == null || !uri.getScheme().equals("file")) {
                return;
            }
            Path path = Path.of(uri);
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    path = path.toRealPath(new LinkOption[0]);
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            } else {
                path = path.normalize();
            }
            if (!path.startsWith(this.rootDir)) {
                String message = ErrorMessages.create(errorMessageKey, uri);
                throw new SecurityManagerException(message);
            }
        }
    }
}

