/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import com.oracle.truffle.api.TruffleOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.pkl.core.Version;

public class Release {
    private static final String SOURCE_CODE_HOMEPAGE = "https://github.com/apple/pkl/";
    private static final String DOCUMENTATION_HOMEPAGE = "https://pkl-lang.org/main/";
    private static final Release CURRENT;
    private final Version version;
    private final String os;
    private final String flavor;
    private final String versionInfo;
    private final String commitId;
    private final SourceCode sourceCode;
    private final Documentation documentation;
    private final StandardLibrary standardLibrary;

    public Release(Version version, String os, String flavor, String versionInfo, String commitId, SourceCode sourceCode, Documentation documentation, StandardLibrary standardLibrary) {
        this.version = version;
        this.os = os;
        this.flavor = flavor;
        this.versionInfo = versionInfo;
        this.commitId = commitId;
        this.sourceCode = sourceCode;
        this.documentation = documentation;
        this.standardLibrary = standardLibrary;
    }

    public static Release current() {
        return CURRENT;
    }

    public Version version() {
        return this.version;
    }

    public String os() {
        return this.os;
    }

    public String flavor() {
        return this.flavor;
    }

    public String versionInfo() {
        return this.versionInfo;
    }

    public String commitId() {
        return this.commitId;
    }

    public SourceCode sourceCode() {
        return this.sourceCode;
    }

    public Documentation documentation() {
        return this.documentation;
    }

    public StandardLibrary standardLibrary() {
        return this.standardLibrary;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Release)) {
            return false;
        }
        Release other = (Release)obj;
        return this.version.equals(other.version) && this.versionInfo.equals(other.versionInfo) && this.commitId.equals(other.commitId) && this.sourceCode.equals(other.sourceCode) && this.documentation.equals(other.documentation) && this.standardLibrary.equals(other.standardLibrary);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.versionInfo, this.commitId, this.sourceCode, this.documentation, this.standardLibrary);
    }

    static {
        Properties properties = new Properties();
        try (InputStream stream = Release.class.getResourceAsStream("Release.properties");){
            if (stream == null) {
                throw new AssertionError((Object)"Failed to locate `Release.properties`.");
            }
            properties.load(stream);
        }
        catch (IOException e2) {
            throw new AssertionError("Failed to load `Release.properties`.", e2);
        }
        Version version = Version.parse(properties.getProperty("version"));
        String commitId = properties.getProperty("commitId");
        String osName = System.getProperty("os.name");
        if (osName.equals("Mac OS X")) {
            osName = "macOS";
        }
        String osVersion = System.getProperty("os.version");
        String os = osName + " " + osVersion;
        String flavor = TruffleOptions.AOT ? "native" : "Java " + System.getProperty("java.version");
        String versionInfo = "Pkl " + version + " (" + os + ", " + flavor + ")";
        String commitish = version.isNormal() ? version.toString() : commitId;
        String docsVersion = version.isNormal() ? version.toString() : "latest";
        String docsHomepage = DOCUMENTATION_HOMEPAGE + docsVersion + "/";
        LinkedHashSet<String> stdlibModules = new LinkedHashSet<String>(List.of(properties.getProperty("stdlibModules").split(",")));
        CURRENT = new Release(version, os, flavor, versionInfo, commitId, new SourceCode(SOURCE_CODE_HOMEPAGE, commitish), new Documentation(docsHomepage), new StandardLibrary(stdlibModules));
    }

    public static final class StandardLibrary {
        private final Set<String> modules;

        public StandardLibrary(Set<String> modules) {
            this.modules = modules;
        }

        public Set<String> modules() {
            return this.modules;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StandardLibrary)) {
                return false;
            }
            StandardLibrary other = (StandardLibrary)obj;
            return this.modules.equals(other.modules);
        }

        public int hashCode() {
            return this.modules.hashCode();
        }
    }

    public static final class Documentation {
        private final String homepage;

        public Documentation(String homepage) {
            this.homepage = homepage;
        }

        public String homepage() {
            return this.homepage;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Documentation)) {
                return false;
            }
            Documentation other = (Documentation)obj;
            return this.homepage.equals(other.homepage);
        }

        public int hashCode() {
            return this.homepage.hashCode();
        }
    }

    public static final class SourceCode {
        private final String homepage;
        private final String version;

        public SourceCode(String homepage, String version) {
            this.homepage = homepage;
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public String homepage() {
            return this.homepage;
        }

        public String getFilePage(String path) {
            return this.homepage + "blob/" + this.version + "/" + path;
        }

        public String getSourceCodeUrlScheme() {
            return this.homepage + "blob/" + this.version + "/stdlib%{path}#L%{line}-L%{endLine}";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SourceCode)) {
                return false;
            }
            SourceCode other = (SourceCode)obj;
            return this.homepage.equals(other.homepage) && this.version.equals(other.version);
        }

        public int hashCode() {
            return Objects.hash(this.homepage, this.version);
        }
    }
}

