/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pkl.core.Member;
import org.pkl.core.Modifier;
import org.pkl.core.PClassInfo;
import org.pkl.core.PObject;
import org.pkl.core.PType;
import org.pkl.core.TypeParameter;
import org.pkl.core.Value;
import org.pkl.core.ValueConverter;
import org.pkl.core.ValueVisitor;
import org.pkl.core.util.Nullable;

public final class PClass
extends Member
implements Value {
    private static final long serialVersionUID = 0L;
    private final PClassInfo<?> classInfo;
    private final List<TypeParameter> typeParameters;
    private final Map<String, Property> properties;
    private final Map<String, Method> methods;
    private @Nullable PType supertype;
    private @Nullable PClass superclass;
    private @Nullable Map<String, Property> allProperties;
    private @Nullable Map<String, Method> allMethods;

    public PClass(@Nullable String docComment, Member.SourceLocation sourceLocation, Set<Modifier> modifiers, List<PObject> annotations, PClassInfo<?> classInfo, List<TypeParameter> typeParameters, Map<String, Property> properties, Map<String, Method> methods) {
        super(docComment, sourceLocation, modifiers, annotations, classInfo.getSimpleName());
        this.classInfo = classInfo;
        this.typeParameters = typeParameters;
        this.properties = properties;
        this.methods = methods;
    }

    public void initSupertype(PType supertype, PClass superclass) {
        this.supertype = supertype;
        this.superclass = superclass;
    }

    @Override
    public String getModuleName() {
        return this.classInfo.getModuleName();
    }

    public String getQualifiedName() {
        return this.classInfo.getQualifiedName();
    }

    public String getDisplayName() {
        return this.classInfo.getDisplayName();
    }

    public PClassInfo<?> getInfo() {
        return this.classInfo;
    }

    public boolean isModuleClass() {
        return this.getInfo().isModuleClass();
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public @Nullable PType getSupertype() {
        return this.supertype;
    }

    public @Nullable PClass getSuperclass() {
        return this.superclass;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public Map<String, Method> getMethods() {
        return this.methods;
    }

    public Map<String, Property> getAllProperties() {
        if (this.allProperties == null) {
            this.allProperties = this.collectAllProperties(this, new LinkedHashMap<String, Property>());
        }
        return this.allProperties;
    }

    public Map<String, Method> getAllMethods() {
        if (this.allMethods == null) {
            this.allMethods = this.collectAllMethods(this, new LinkedHashMap<String, Method>());
        }
        return this.allMethods;
    }

    @Override
    public void accept(ValueVisitor visitor) {
        visitor.visitClass(this);
    }

    @Override
    public <T> T accept(ValueConverter<T> converter) {
        return converter.convertClass(this);
    }

    @Override
    public PClassInfo<?> getClassInfo() {
        return PClassInfo.Class;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private Map<String, Property> collectAllProperties(PClass clazz, Map<String, Property> collector) {
        if (clazz.superclass != null) {
            this.collectAllProperties(clazz.superclass, collector);
        }
        collector.putAll(clazz.properties);
        return collector;
    }

    private Map<String, Method> collectAllMethods(PClass clazz, Map<String, Method> collector) {
        if (clazz.superclass != null) {
            this.collectAllMethods(clazz.superclass, collector);
        }
        collector.putAll(clazz.methods);
        return collector;
    }

    public static final class Method
    extends ClassMember {
        private static final long serialVersionUID = 0L;
        private final List<TypeParameter> typeParameters;
        private final Map<String, PType> parameters;
        private final PType returnType;

        public Method(PClass owner, @Nullable String docComment, Member.SourceLocation sourceLocation, Set<Modifier> modifiers, List<PObject> annotations, String simpleName2, List<TypeParameter> typeParameters, Map<String, PType> parameters, PType returnType) {
            super(docComment, sourceLocation, modifiers, annotations, simpleName2, owner);
            this.typeParameters = typeParameters;
            this.parameters = parameters;
            this.returnType = returnType;
        }

        public List<TypeParameter> getTypeParameters() {
            return this.typeParameters;
        }

        public Map<String, PType> getParameters() {
            return this.parameters;
        }

        public PType getReturnType() {
            return this.returnType;
        }

        @Override
        public @Nullable String getInheritedDocComment() {
            if (this.getDocComment() != null) {
                return this.getDocComment();
            }
            for (PClass clazz = this.getOwner().getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
                Method method = clazz.getMethods().get(this.getSimpleName());
                if (method == null || method.getDocComment() == null) continue;
                return method.getDocComment();
            }
            return null;
        }
    }

    public static final class Property
    extends ClassMember {
        private static final long serialVersionUID = 0L;
        private final PType type;

        public Property(PClass owner, @Nullable String docComment, Member.SourceLocation sourceLocation, Set<Modifier> modifiers, List<PObject> annotations, String simpleName2, PType type) {
            super(docComment, sourceLocation, modifiers, annotations, simpleName2, owner);
            this.type = type;
        }

        public PType getType() {
            return this.type;
        }

        @Override
        public @Nullable String getInheritedDocComment() {
            if (this.getDocComment() != null) {
                return this.getDocComment();
            }
            for (PClass clazz = this.getOwner().getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
                Property property = clazz.getProperties().get(this.getSimpleName());
                if (property == null || property.getDocComment() == null) continue;
                return property.getDocComment();
            }
            return null;
        }
    }

    public static abstract class ClassMember
    extends Member {
        private static final long serialVersionUID = 0L;
        private final PClass owner;

        public ClassMember(@Nullable String docComment, Member.SourceLocation sourceLocation, Set<Modifier> modifiers, List<PObject> annotations, String simpleName2, PClass owner) {
            super(docComment, sourceLocation, modifiers, annotations, simpleName2);
            this.owner = owner;
        }

        @Override
        public String getModuleName() {
            return this.owner.getInfo().getModuleName();
        }

        public PClass getOwner() {
            return this.owner;
        }

        public abstract @Nullable String getInheritedDocComment();
    }
}

