/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.pkl.core.ImportGraph;
import org.pkl.core.util.Nullable;

public class ImportGraphUtils {
    private ImportGraphUtils() {
    }

    public static List<List<URI>> findImportCycles(ImportGraph importGraph2) {
        ArrayList<List<URI>> res = new ArrayList<List<URI>>();
        for (URI uri : importGraph2.imports().keySet()) {
            List<URI> cycle;
            if (res.stream().anyMatch(it -> it.contains(uri)) || (cycle = ImportGraphUtils.doFindCycle(uri, importGraph2, new ArrayList<URI>(List.of(uri)))) == null) continue;
            res.add(cycle);
        }
        return res;
    }

    @Nullable
    private static List<URI> doFindCycle(URI currentUri, ImportGraph importGraph2, List<URI> path2) {
        Set<ImportGraph.Import> imports = importGraph2.imports().get(currentUri);
        URI startingUri = path2.get(0);
        for (ImportGraph.Import imprt : imports) {
            URI uri = imprt.uri();
            if (uri.equals(startingUri)) {
                return path2;
            }
            if (path2.contains(uri)) {
                return null;
            }
            path2.add(uri);
            List<URI> cycle = ImportGraphUtils.doFindCycle(uri, importGraph2, path2);
            if (cycle != null) {
                return cycle;
            }
            path2.remove(path2.size() - 1);
        }
        return null;
    }
}

