/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.test.report;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.pkl.core.TestResults;
import org.pkl.core.stdlib.test.report.TestReport;
import org.pkl.core.util.AnsiStringBuilder;
import org.pkl.core.util.AnsiTheme;
import org.pkl.core.util.StringUtils;

public final class SimpleReport
implements TestReport {
    private static final String passingMark = "\u2714 ";
    private static final String failingMark = "\u2718 ";
    private final boolean useColor;

    public SimpleReport(boolean useColor2) {
        this.useColor = useColor2;
    }

    @Override
    public void report(TestResults results, Writer writer) throws IOException {
        AnsiStringBuilder builder = new AnsiStringBuilder(this.useColor);
        builder.append("module ").append(results.moduleName()).append('\n');
        if (results.error() != null) {
            String rendered = results.error().exception().getMessage();
            SimpleReport.appendPadded(builder, rendered, "  ");
            builder.append('\n');
        } else {
            this.reportResults(results.facts(), builder);
            this.reportResults(results.examples(), builder);
        }
        writer.append(builder.toString());
    }

    public void summarize(List<TestResults> allTestResults, Writer writer) throws IOException {
        int totalTests = 0;
        int totalFailedTests = 0;
        int totalAsserts = 0;
        int totalFailedAsserts = 0;
        boolean isFailed = false;
        boolean isExampleWrittenFailure = true;
        for (TestResults testResults : allTestResults) {
            if (!isFailed) {
                isFailed = testResults.failed();
            }
            if (testResults.failed()) {
                isExampleWrittenFailure = testResults.isExampleWrittenFailure() & isExampleWrittenFailure;
            }
            totalTests += testResults.totalTests();
            totalFailedTests += testResults.totalFailures();
            totalAsserts += testResults.totalAsserts();
            totalFailedAsserts += testResults.totalAssertsFailed();
        }
        AnsiStringBuilder builder = new AnsiStringBuilder(this.useColor);
        if (isFailed && isExampleWrittenFailure) {
            builder.append(totalFailedTests).append(" examples written");
        } else {
            this.makeStatsLine(builder, "tests", totalTests, totalFailedTests, isFailed);
            builder.append(", ");
            this.makeStatsLine(builder, "asserts", totalAsserts, totalFailedAsserts, isFailed);
        }
        builder.append('\n');
        writer.append(builder.toString());
    }

    private void reportResults(TestResults.TestSectionResults section, AnsiStringBuilder builder) {
        if (!section.results().isEmpty()) {
            builder.append("  ").append((Object)section.name()).append('\n');
            StringUtils.joinToStringBuilder(builder, section.results(), "\n", res -> this.reportResult((TestResults.TestResult)res, builder));
            builder.append('\n');
        }
    }

    private void reportResult(TestResults.TestResult result, AnsiStringBuilder builder) {
        builder.append("    ");
        if (result.isExampleWritten()) {
            builder.append("\u270d\ufe0f ").append(result.name());
        } else {
            if (result.isFailure()) {
                builder.append(AnsiTheme.FAILING_TEST_MARK, failingMark);
            } else {
                builder.append(AnsiTheme.PASSING_TEST_MARK, passingMark);
            }
            builder.append(AnsiTheme.TEST_NAME, result.name());
            if (result.isFailure()) {
                String failurePadding = "       ";
                builder.append("\n");
                StringUtils.joinToStringBuilder(builder, result.failures(), "\n", failure -> SimpleReport.appendPadded(builder, failure.message(), failurePadding));
                StringUtils.joinToStringBuilder(builder, result.errors(), "\n", error -> SimpleReport.appendPadded(builder, error.exception().getMessage(), failurePadding));
            }
        }
    }

    private static void appendPadded(AnsiStringBuilder builder, String lines, String padding) {
        StringUtils.joinToStringBuilder(builder, (Iterable)lines.lines().collect(Collectors.toList()), "\n", str -> {
            if (!str.isEmpty()) {
                builder.append(padding).append((String)str);
            }
        });
    }

    private void makeStatsLine(AnsiStringBuilder sb, String kind, int total, int failed, boolean isFailed) {
        int passed = total - failed;
        double passRate = total > 0 ? 100.0 * (double)passed / (double)total : 0.0;
        AnsiStringBuilder.AnsiCode color = isFailed ? AnsiStringBuilder.AnsiCode.RED : AnsiStringBuilder.AnsiCode.GREEN;
        sb.append(color, () -> sb.append(String.format(Locale.ROOT, "%.1f%%", passRate)).append(" ").append(kind).append(" pass"));
        if (isFailed) {
            sb.append(" [").append(failed).append('/').append(total).append(" failed]");
        } else {
            sb.append(" [").append(passed).append(" passed]");
        }
    }
}

