/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.test.report;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.graalvm.collections.EconomicMap;
import org.pkl.core.TestResults;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.XmlModule;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.stdlib.test.report.TestReport;
import org.pkl.core.stdlib.xml.RendererNodes;
import org.pkl.core.util.EconomicMaps;

public final class JUnitReport
implements TestReport {
    @Override
    public void report(TestResults results, Writer writer) throws IOException {
        writer.append(JUnitReport.renderXML("    ", "1.0", this.buildSuite(results)));
    }

    private VmDynamic buildSuite(TestResults results) {
        if (results.error() != null) {
            VmDynamic testCase = this.rootTestCase(results, results.error());
            VmMapping attrs = this.buildAttributes("name", results.moduleName(), "tests", 1, "failures", 1);
            return this.buildXmlElement("testsuite", attrs, testCase);
        }
        ArrayList<VmDynamic> testCases = this.testCases(results.moduleName(), results.facts());
        testCases.addAll(this.testCases(results.moduleName(), results.examples()));
        if (!results.logs().isBlank()) {
            VmDynamic err = this.buildXmlElement("system-err", VmMapping.empty(), (EconomicMap<Object, ObjectMember> members) -> members.put("body", this.syntheticElement(this.makeCdata(results.logs()))));
            testCases.add(err);
        }
        VmMapping attrs = this.buildAttributes("name", results.moduleName(), "tests", results.totalTests(), "failures", results.totalFailures());
        return this.buildXmlElement("testsuite", attrs, testCases.toArray(new VmDynamic[0]));
    }

    private VmDynamic rootTestCase(TestResults results, TestResults.Error error) {
        VmMapping testCaseAttrs = this.buildAttributes("classname", results.moduleName(), "name", results.moduleName());
        ArrayList<VmDynamic> err = this.error(error);
        return this.buildXmlElement("testcase", testCaseAttrs, err.toArray(new VmDynamic[0]));
    }

    private ArrayList<VmDynamic> testCases(String moduleName, TestResults.TestSectionResults testSectionResults) {
        ArrayList<VmDynamic> elements = new ArrayList<VmDynamic>(testSectionResults.totalTests());
        for (TestResults.TestResult res : testSectionResults.results()) {
            VmMapping attrs = this.buildAttributes("classname", moduleName + "." + testSectionResults.name(), "name", res.name());
            ArrayList<VmDynamic> failures = this.failures(res);
            failures.addAll(this.errors(res));
            VmDynamic element = this.buildXmlElement("testcase", attrs, failures.toArray(new VmDynamic[0]));
            elements.add(element);
        }
        return elements;
    }

    private ArrayList<VmDynamic> failures(TestResults.TestResult res) {
        ArrayList<VmDynamic> list = new ArrayList<VmDynamic>();
        long i = 0L;
        for (TestResults.Failure fail : res.failures()) {
            long element;
            VmMapping attrs = this.buildAttributes("message", fail.kind());
            ++i;
            list.add(this.buildXmlElement("failure", attrs, (EconomicMap<Object, ObjectMember> members) -> members.put(element, this.syntheticElement(this.stripColors(fail.message())))));
        }
        return list;
    }

    private ArrayList<VmDynamic> errors(TestResults.TestResult res) {
        ArrayList<VmDynamic> list = new ArrayList<VmDynamic>();
        long i = 0L;
        for (TestResults.Error error : res.errors()) {
            long element;
            VmMapping attrs = this.buildAttributes("message", error.message());
            ++i;
            list.add(this.buildXmlElement("error", attrs, (EconomicMap<Object, ObjectMember> members) -> members.put(element, this.syntheticElement(this.stripColors(error.exception().getMessage())))));
        }
        return list;
    }

    private ArrayList<VmDynamic> error(TestResults.Error error) {
        ArrayList<VmDynamic> list = new ArrayList<VmDynamic>();
        VmMapping attrs = this.buildAttributes("message", error.message());
        list.add(this.buildXmlElement("error", attrs, (EconomicMap<Object, ObjectMember> members) -> members.put(1, this.syntheticElement(this.stripColors("\n" + error.exception().getMessage())))));
        return list;
    }

    private VmDynamic buildXmlElement(String name, VmMapping attributes, VmDynamic ... elements) {
        return this.buildXmlElement(name, attributes, (EconomicMap<Object, ObjectMember> members) -> {
            long i = 0L;
            for (VmDynamic element : elements) {
                members.put(i++, this.syntheticElement(element));
            }
        });
    }

    private VmDynamic buildXmlElement(String name, VmMapping attributes, Consumer<EconomicMap<Object, ObjectMember>> gen) {
        EconomicMap<Object, ObjectMember> members = EconomicMaps.of(Identifier.IS_XML_ELEMENT, VmUtils.createSyntheticObjectProperty(Identifier.IS_XML_ELEMENT, "", true), Identifier.NAME, VmUtils.createSyntheticObjectProperty(Identifier.NAME, "", name), Identifier.ATTRIBUTES, VmUtils.createSyntheticObjectProperty(Identifier.ATTRIBUTES, "", attributes), Identifier.IS_BLOCK_FORMAT, VmUtils.createSyntheticObjectProperty(Identifier.IS_BLOCK_FORMAT, "", true));
        gen.accept(members);
        return new VmDynamic(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getDynamicClass().getPrototype(), members, members.size() - 4);
    }

    private VmMapping buildAttributes(Object ... attributes) {
        EconomicMap<Object, ObjectMember> attrs = EconomicMaps.create(attributes.length);
        for (int i = 0; i < attributes.length; i += 2) {
            attrs.put(attributes[i], VmUtils.createSyntheticObjectEntry(attributes[i].toString(), attributes[i + 1]));
        }
        return new VmMapping(VmUtils.createEmptyMaterializedFrame(), BaseModule.getMappingClass().getPrototype(), attrs);
    }

    private ObjectMember syntheticElement(Object constantValue) {
        return VmUtils.createSyntheticObjectElement("", constantValue);
    }

    private VmTyped makeCdata(String text) {
        VmClass clazz = XmlModule.getCDataClass();
        EconomicMap<Object, ObjectMember> attrs = EconomicMaps.of(Identifier.TEXT, VmUtils.createSyntheticObjectProperty(null, "", text));
        return new VmTyped(VmUtils.createEmptyMaterializedFrame(), clazz.getPrototype(), clazz, attrs);
    }

    private String stripColors(String str) {
        return str.replaceAll("\u001b\\[[;\\d]*m", "");
    }

    private static String renderXML(String indent, String version, VmDynamic value2) {
        StringBuilder builder = new StringBuilder();
        PklConverter converter = new PklConverter(VmMapping.empty());
        RendererNodes.Renderer renderer = new RendererNodes.Renderer(builder, indent, version, "", VmMapping.empty(), converter);
        renderer.renderDocument(value2);
        return builder.toString();
    }
}

