/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.protobuf;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Optional;
import org.pkl.core.DurationUnit;
import org.pkl.core.ast.member.ClassProperty;
import org.pkl.core.ast.member.PropertyTypeNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.stdlib.AbstractRenderer;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.util.ArrayCharEscaper;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.json.JsonEscaper;

public final class RendererNodes {
    private static final Identifier SECONDS = Identifier.get("seconds");
    private static final Identifier NANOS = Identifier.get("nanos");
    private static final ArrayCharEscaper fieldNameEscaper = ArrayCharEscaper.builder().withEscape('.', "_").withEscape('#', "_").build();
    private static final TypeNode.StringTypeNode STRING_TYPE = new TypeNode.StringTypeNode(VmUtils.unavailableSourceSection());
    private static final TypeNode.IntTypeNode INT_TYPE = new TypeNode.IntTypeNode(VmUtils.unavailableSourceSection());

    private RendererNodes() {
    }

    @CompilerDirectives.TruffleBoundary
    private static String renderType(Object value2) {
        String string;
        Object clazz;
        if (value2 instanceof VmValue) {
            VmValue vmValue = (VmValue)value2;
            v0 = vmValue.getVmClass();
        } else if (value2 instanceof TypeNode) {
            TypeNode typeNode = (TypeNode)value2;
            v0 = typeNode.getVmClass();
        } else {
            v0 = clazz = value2.getClass();
        }
        if (clazz == null) {
            throw new VmExceptionBuilder().evalError("cannotResolveTypeForProtobuf", new Object[0]).withProgramValue("Value", value2).build();
        }
        if (clazz instanceof VmClass) {
            VmClass vmClass = (VmClass)clazz;
            string = vmClass.getSimpleName();
        } else {
            string = ((Class)clazz).getSimpleName();
        }
        String name = string;
        return fieldNameEscaper.escape(name);
    }

    @CompilerDirectives.TruffleBoundary
    private static ProtobufRenderer createRenderer(VmTyped self, StringBuilder builder) {
        String indent = (String)VmUtils.readMember(self, Identifier.INDENT);
        VmMapping converters = (VmMapping)VmUtils.readMember(self, Identifier.CONVERTERS);
        return new ProtobufRenderer(builder, indent, new PklConverter(converters));
    }

    private static final class ProtobufRenderer
    extends AbstractRenderer {
        private final Deque<Identifier> propertyPath = new ArrayDeque<Identifier>();
        private final Deque<Boolean> wrapperRequirement = new ArrayDeque<Boolean>();
        private final JsonEscaper jsonEscaper = new JsonEscaper(false);
        @Nullable
        private TypeNode collectionType = null;

        public ProtobufRenderer(StringBuilder builder, String indent, PklConverter converter) {
            super("Protobuf", builder, indent, converter, true, true);
        }

        @Override
        protected void visitDocument(Object value2) {
            this.visit(value2);
            this.startNewLine();
        }

        @Override
        protected void visitTopLevelValue(Object value2) {
            if (value2 instanceof VmValue && !(value2 instanceof VmTyped) && !(value2 instanceof VmDuration)) {
                String name = value2.getClass().getSimpleName();
                if (name.startsWith("Vm")) {
                    name = name.substring(2);
                }
                throw new VmExceptionBuilder().evalError("invalidProtobufTopLevelValue", name).build();
            }
            assert (this.propertyPath.isEmpty() && this.wrapperRequirement.isEmpty()) : "Corrupted traversal stack.";
            this.wrapperRequirement.push(false);
            this.visit(value2);
            Boolean wrap = this.wrapperRequirement.pop();
            assert (!wrap.booleanValue() && this.propertyPath.isEmpty() && this.wrapperRequirement.isEmpty()) : "Corrupted traversal stack.";
        }

        @Override
        protected void visitRenderDirective(VmTyped value2) {
            this.writePropertyName();
            this.builder.append(VmUtils.readTextProperty(value2));
        }

        @Override
        protected void startDynamic(VmDynamic value2) {
            throw new VmExceptionBuilder().evalError("cannotRenderTypeAddConverter", "Dynamic", "Protobuf").withProgramValue("Value", value2).build();
        }

        @Override
        protected void endDynamic(VmDynamic value2, boolean isEmpty2) {
        }

        @Override
        protected void startTyped(VmTyped value2) {
            this.wrapperRequirement.push(false);
            if (!this.propertyPath.isEmpty()) {
                this.writePropertyName();
                this.startMessage();
            }
        }

        @Override
        protected void endTyped(VmTyped value2, boolean isEmpty2) {
            Boolean popped = this.wrapperRequirement.pop();
            assert (!popped.booleanValue()) : "Corrupted traversal stack.";
            if (!this.propertyPath.isEmpty()) {
                this.endMessage();
            }
        }

        @Override
        protected void startListing(VmListing value2) {
            this.startWrapper();
        }

        @Override
        protected void endListing(VmListing value2, boolean isEmpty2) {
            this.endWrapper();
        }

        @Override
        protected void startMapping(VmMapping value2) {
            this.startMaplike();
        }

        @Override
        protected void endMapping(VmMapping value2, boolean isEmpty2) {
            this.endMaplike();
        }

        private void startMaplike() {
            if (this.requiresWrapper()) {
                this.writePropertyName();
                this.propertyPath.push(Identifier.IT);
                this.startMessage();
            }
            this.wrapperRequirement.push(true);
        }

        private void endMaplike() {
            this.wrapperRequirement.pop();
            if (this.requiresWrapper()) {
                this.endMessage();
                Identifier popped = this.propertyPath.pop();
                assert (popped == Identifier.IT) : "Corrupted traversal stack.";
            }
        }

        @Override
        protected void startList(VmList value2) {
            this.startWrapper();
        }

        @Override
        protected void endList(VmList value2) {
            this.endWrapper();
        }

        @Override
        protected void startSet(VmSet value2) {
            this.startWrapper();
        }

        @Override
        protected void endSet(VmSet value2) {
            this.endWrapper();
        }

        @Override
        protected void startMap(VmMap value2) {
            this.startMaplike();
        }

        @Override
        protected void endMap(VmMap value2) {
            this.endMaplike();
        }

        @Override
        protected void visitElement(long index, Object value2, boolean isFirst) {
            if (this.requiresWrapper()) {
                this.propertyPath.push(Identifier.IT);
            }
            String typeName = this.computeName(this.collectionType, value2);
            boolean addedType = false;
            if (typeName != null) {
                addedType = true;
                this.writePropertyName();
                this.startMessage();
                this.propertyPath.push(Identifier.get("it_" + typeName));
            }
            this.wrapperRequirement.push(true);
            this.visit(value2);
            Boolean popped = this.wrapperRequirement.pop();
            assert (popped.booleanValue()) : "Corrupted traversal stack.";
            if (addedType) {
                this.propertyPath.pop();
                this.endMessage();
            }
            if (this.requiresWrapper()) {
                this.propertyPath.pop();
            }
        }

        @Override
        protected void visitEntryKey(Object key2, boolean isFirst) {
            boolean isValidKey;
            boolean isDirective = VmUtils.isRenderDirective(key2);
            boolean bl = isValidKey = isDirective || key2 instanceof Long || key2 instanceof Boolean || key2 instanceof String;
            if (!isValidKey) {
                throw new VmExceptionBuilder().evalError("cannotRenderNonScalarMapKey", new Object[0]).withProgramValue("Key", key2).build();
            }
            this.writePropertyName();
            this.startMessage();
            this.startNewLine();
            this.builder.append("key: ");
            if (isDirective) {
                this.builder.append(VmUtils.readTextProperty(key2));
            } else if (key2 instanceof String) {
                String string = (String)key2;
                this.builder.append('\"').append(this.jsonEscaper.escape(string)).append('\"');
            } else {
                this.builder.append(key2);
            }
        }

        @Override
        protected void visitEntryValue(Object value2) {
            this.propertyPath.push(Identifier.VALUE);
            this.visit(value2);
            this.propertyPath.pop();
            this.endMessage();
        }

        @Nullable
        private String computeName(@Nullable TypeNode it, Object value2) {
            if (it instanceof TypeNode.UnionTypeNode) {
                TypeNode.UnionTypeNode unionTypeNode = (TypeNode.UnionTypeNode)it;
                for (TypeNode type : unionTypeNode.getElementTypeNodes()) {
                    if (type instanceof TypeNode.UnionTypeNode) {
                        String computedName = this.computeName(type, value2);
                        if (computedName != null) {
                            return computedName;
                        }
                    } else if (type instanceof TypeNode.NonFinalClassTypeNode) {
                        VmValue vmValue;
                        VmClass clazz = type.getVmClass();
                        if (value2 instanceof VmValue && clazz == (vmValue = (VmValue)value2).getVmClass()) {
                            return clazz.getSimpleName();
                        }
                    }
                    try {
                        type.execute(VmUtils.createEmptyMaterializedFrame(), value2);
                    }
                    catch (VmTypeMismatchException e2) {
                        continue;
                    }
                    return RendererNodes.renderType(type);
                }
            }
            return null;
        }

        @Override
        protected void visitProperty(Identifier name, Object value2, boolean isFirst) {
            Identifier popped;
            boolean hasWrapper = false;
            boolean hasCollection = false;
            TypeNode prevCollectionType = this.collectionType;
            Identifier expectedName = null;
            this.propertyPath.push(name);
            if (this.enclosingValue instanceof VmTyped) {
                Object object;
                if (value2 instanceof VmValue) {
                    VmValue vmValue = (VmValue)value2;
                    object = vmValue.getVmClass();
                } else {
                    object = value2.getClass();
                }
                Class<?> clazz = object;
                Optional<TypeNode> optionalType = Optional.of(name).map(this.enclosingValue.getVmClass()::getProperty).map(ClassProperty::getTypeNode).map(PropertyTypeNode::getTypeNode).map(this::resolveType);
                if (optionalType.isPresent()) {
                    TypeNode type = optionalType.get();
                    String computedName = this.computeName(type, value2);
                    if (computedName != null) {
                        hasWrapper = true;
                        this.writePropertyName();
                        expectedName = Identifier.get("it_" + computedName);
                        this.propertyPath.push(expectedName);
                        this.startMessage();
                    } else if (type instanceof TypeNode.ListingOrMappingTypeNode) {
                        TypeNode.ListingOrMappingTypeNode listingOrMappingType = (TypeNode.ListingOrMappingTypeNode)type;
                        hasCollection = true;
                        this.collectionType = listingOrMappingType.getValueTypeNode();
                    } else if (type instanceof TypeNode.ListTypeNode) {
                        TypeNode.ListTypeNode listType = (TypeNode.ListTypeNode)type;
                        hasCollection = true;
                        this.collectionType = listType.getElementTypeNode();
                    } else if (type instanceof TypeNode.MapTypeNode) {
                        TypeNode.MapTypeNode mapType = (TypeNode.MapTypeNode)type;
                        hasCollection = true;
                        this.collectionType = mapType.getValueTypeNode();
                    } else if (type instanceof TypeNode.SetTypeNode) {
                        TypeNode.SetTypeNode setType = (TypeNode.SetTypeNode)type;
                        hasCollection = true;
                        this.collectionType = setType.getElementTypeNode();
                    } else if (type instanceof TypeNode.NonFinalClassTypeNode && type.getVmClass() != clazz) {
                        throw new VmExceptionBuilder().evalError("cannotRenderSubtypeForProtobuf", type.getVmClass(), clazz).build();
                    }
                }
            }
            this.visit(value2);
            if (hasWrapper) {
                this.endMessage();
                popped = this.propertyPath.pop();
                assert (popped == expectedName) : "Corrupted traversal stack.";
            } else if (hasCollection) {
                this.collectionType = prevCollectionType;
            }
            popped = this.propertyPath.pop();
            assert (name == popped) : "Corrupted traversal stack.";
        }

        private void startNewLine() {
            if (this.indent.isEmpty() || this.builder.isEmpty() || this.builder.charAt(this.builder.length() - 1) == '\n') {
                return;
            }
            this.builder.append('\n');
            this.builder.append((CharSequence)this.currIndent);
        }

        private void startWrapper() {
            if (this.requiresWrapper()) {
                this.writePropertyName();
                this.startMessage();
            }
        }

        private void endWrapper() {
            if (this.requiresWrapper()) {
                this.endMessage();
            }
        }

        private boolean requiresWrapper() {
            Boolean result = this.wrapperRequirement.peek();
            assert (result != null) : "Corrupted traversal stack.";
            return result;
        }

        private void startMessage() {
            this.builder.append('{');
            this.increaseIndent();
        }

        private void endMessage() {
            this.decreaseIndent();
            if (this.builder.charAt(this.builder.length() - 1) != '{') {
                this.startNewLine();
            }
            this.builder.append('}');
        }

        private void writePropertyName() {
            if (this.propertyPath.isEmpty()) {
                return;
            }
            this.startNewLine();
            Identifier name = this.propertyPath.peek();
            assert (name != null) : "Corrupted traversal stack.";
            this.builder.append(name);
            this.builder.append(": ");
        }

        @Override
        public void visitString(String value2) {
            this.writePropertyName();
            this.builder.append('\"').append(this.jsonEscaper.escape(value2)).append('\"');
        }

        @Override
        public void visitBoolean(Boolean value2) {
            this.writePropertyName();
            this.builder.append(value2);
        }

        @Override
        public void visitInt(Long value2) {
            this.writePropertyName();
            this.builder.append(value2);
        }

        @Override
        public void visitFloat(Double value2) {
            this.writePropertyName();
            this.builder.append(value2);
        }

        @Override
        public void visitDuration(VmDuration value2) {
            this.writePropertyName();
            long nanos = (long)value2.convertTo(DurationUnit.NANOS).getValue() % 1000000000L;
            long seconds = (long)Math.floor(value2.convertTo(DurationUnit.SECONDS).getValue());
            this.startMessage();
            this.propertyPath.push(SECONDS);
            this.writePropertyName();
            this.builder.append(seconds);
            this.propertyPath.pop();
            this.propertyPath.push(NANOS);
            this.writePropertyName();
            this.builder.append(nanos);
            this.propertyPath.pop();
            this.endMessage();
        }

        @Override
        public void visitDataSize(VmDataSize value2) {
            throw new VmExceptionBuilder().evalError("cannotRenderTypeAddConverter", "DataSize", "Protobuf").withProgramValue("Value", value2).build();
        }

        @Override
        public void visitIntSeq(VmIntSeq value2) {
            this.writePropertyName();
            this.builder.append(value2);
        }

        @Override
        public void visitPair(VmPair value2) {
            this.writePropertyName();
            this.builder.append(value2);
        }

        @Override
        public void visitRegex(VmRegex value2) {
            this.writePropertyName();
            this.builder.append(value2);
        }

        @Override
        public void visitNull(VmNull value2) {
            this.writePropertyName();
            this.builder.append(value2);
        }

        @Nullable
        private TypeNode resolveType(@Nullable TypeNode type) {
            if (type instanceof TypeNode.IntTypeNode || type instanceof TypeNode.StringTypeNode || type instanceof TypeNode.BooleanTypeNode) {
                return type;
            }
            if (type instanceof TypeNode.IntSlotTypeNode) {
                return INT_TYPE;
            }
            if (type instanceof TypeNode.UnionOfStringLiteralsTypeNode || type instanceof TypeNode.StringLiteralTypeNode) {
                return STRING_TYPE;
            }
            if (type instanceof TypeNode.NullableTypeNode) {
                TypeNode.NullableTypeNode nullableType = (TypeNode.NullableTypeNode)type;
                return this.resolveType(nullableType.getElementTypeNode());
            }
            if (type instanceof TypeNode.TypeAliasTypeNode) {
                TypeNode.TypeAliasTypeNode typeAliasType = (TypeNode.TypeAliasTypeNode)type;
                return this.resolveType(typeAliasType.getVmTypeAlias().getTypeNode());
            }
            if (type instanceof TypeNode.ListingTypeNode) {
                TypeNode.ListingTypeNode listingType = (TypeNode.ListingTypeNode)type;
                TypeNode valueType = this.resolveType(listingType.getValueTypeNode());
                assert (valueType != null) : "Failed to resolve type node.";
                type = this.requiresWrapper() ? null : new TypeNode.ListingTypeNode(VmUtils.unavailableSourceSection(), VmLanguage.get(null), valueType);
                return type;
            }
            if (type instanceof TypeNode.MappingTypeNode) {
                TypeNode.MappingTypeNode mappingType = (TypeNode.MappingTypeNode)type;
                TypeNode keyType = this.resolveType(mappingType.getKeyTypeNode());
                if (!(keyType instanceof TypeNode.IntTypeNode || keyType instanceof TypeNode.StringTypeNode || keyType instanceof TypeNode.BooleanTypeNode)) {
                    throw new VmExceptionBuilder().evalError("cannotRenderNonScalarMapKeyType", new Object[0]).withSourceSection(type.getSourceSection()).build();
                }
                TypeNode valueType = this.resolveType(mappingType.getValueTypeNode());
                assert (valueType != null) : "Incomplete or malformed Mapping type";
                mappingType = new TypeNode.MappingTypeNode(VmUtils.unavailableSourceSection(), VmLanguage.get(null), keyType, valueType);
                type = this.requiresWrapper() ? null : mappingType;
                return type;
            }
            if (type instanceof TypeNode.UnionTypeNode) {
                boolean hasString = false;
                ArrayList<TypeNode> elements = new ArrayList<TypeNode>();
                for (TypeNode t : ((TypeNode.UnionTypeNode)type).getElementTypeNodes()) {
                    TypeNode resolved = this.resolveType(t);
                    if (resolved instanceof TypeNode.StringLiteralTypeNode || resolved instanceof TypeNode.StringTypeNode) {
                        if (hasString) continue;
                        hasString = true;
                        elements.add(new TypeNode.StringTypeNode(VmUtils.unavailableSourceSection()));
                        continue;
                    }
                    elements.add(resolved);
                }
                elements.sort((o1, o2) -> {
                    if (o1 instanceof TypeNode.ObjectSlotTypeNode && o2 instanceof TypeNode.ObjectSlotTypeNode) {
                        VmClass t1 = o1.getVmClass();
                        VmClass t2 = o2.getVmClass();
                        if (t1 == null || t2 == null) {
                            return 0;
                        }
                        return t1.isSubclassOf(t2) ? -1 : (t2.isSubclassOf(t1) ? 1 : 0);
                    }
                    return 0;
                });
                type = hasString && elements.size() == 1 ? (TypeNode)elements.get(0) : new TypeNode.UnionTypeNode(VmUtils.unavailableSourceSection(), -1, elements.toArray(new TypeNode[0]), false);
                return type;
            }
            return type;
        }
    }

    public static abstract class renderType
    extends ExternalMethod1Node {
        @Specialization
        protected String eval(VmTyped self, Object value2) {
            return RendererNodes.renderType(value2);
        }
    }

    public static abstract class renderValue
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            RendererNodes.createRenderer(self, builder).renderValue(value2);
            return builder.toString();
        }
    }

    public static abstract class renderDocument
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            RendererNodes.createRenderer(self, builder).renderDocument(value2);
            return builder.toString();
        }
    }
}

