/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import org.pkl.core.DurationUnit;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.util.DurationUtils;
import org.pkl.core.util.MathUtils;

public final class DurationNodes {
    private DurationNodes() {
    }

    public static abstract class toUnit
    extends ExternalMethod1Node {
        @Specialization
        protected VmDuration eval(VmDuration self, String str) {
            DurationUnit unit2 = DurationUnit.parse(str);
            assert (unit2 != null);
            return self.convertTo(unit2);
        }
    }

    public static abstract class isBetween
    extends ExternalMethod2Node {
        @Specialization
        protected boolean eval(VmDuration self, VmDuration start2, VmDuration inclusiveEnd) {
            return self.compareTo(start2) >= 0 && self.compareTo(inclusiveEnd) <= 0;
        }
    }

    public static abstract class isPositive
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(VmDuration self) {
            return self.getValue() >= 0.0;
        }
    }

    public static abstract class unit
    extends ExternalPropertyNode {
        @Specialization
        protected String eval(VmDuration self) {
            return self.getUnit().getSymbol();
        }
    }

    public static abstract class isoString
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmDuration self) {
            try {
                return DurationUtils.toIsoString(self.getValue(), self.getUnit());
            }
            catch (ArithmeticException e2) {
                throw this.exceptionBuilder().evalError("cannotConvertToIsoDuration", self).build();
            }
        }
    }

    @ImportStatic(value={MathUtils.class})
    public static abstract class value
    extends ExternalPropertyNode {
        @Specialization(guards={"isMathematicalInteger(self.getValue())"})
        protected long evalInt(VmDuration self) {
            return (long)self.getValue();
        }

        @Specialization(guards={"!isMathematicalInteger(self.getValue())"})
        protected double evalFloat(VmDuration self) {
            return self.getValue();
        }
    }
}

