/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.MaterializedFrame;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.pkl.core.ast.member.ListingOrMappingTypeCastNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmListingOrMapping;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.Nullable;

public final class VmListing
extends VmListingOrMapping {
    private final int length;

    public static VmListing empty() {
        return EmptyHolder.EMPTY;
    }

    public VmListing(MaterializedFrame enclosingFrame, VmObject parent, UnmodifiableEconomicMap<Object, ObjectMember> members, int length2) {
        super(enclosingFrame, parent, members);
        this.length = length2;
    }

    public VmListing(MaterializedFrame enclosingFrame, VmObject parent, UnmodifiableEconomicMap<Object, ObjectMember> members, int length2, ListingOrMappingTypeCastNode typeCastNode, Object typeCheckReceiver, VmObjectLike typeCheckOwner) {
        super(enclosingFrame, parent, members, typeCastNode, typeCheckReceiver, typeCheckOwner);
        this.length = length2;
    }

    public static boolean isDefaultProperty(Object propertyKey) {
        return propertyKey == Identifier.DEFAULT;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean isSequence() {
        return true;
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getListingClass();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> export() {
        ArrayList<Object> properties = new ArrayList<Object>(EconomicMaps.size(this.cachedValues));
        this.iterateMemberValues((key2, prop, value2) -> {
            if (VmListing.isDefaultProperty(key2)) {
                return true;
            }
            properties.add(VmValue.exportNullable(value2));
            return true;
        });
        return properties;
    }

    @Override
    public void accept(VmValueVisitor visitor) {
        visitor.visitListing(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path2) {
        return converter.convertListing(this, path2);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VmListing)) {
            return false;
        }
        VmListing other = (VmListing)obj;
        if (this.length != other.length) {
            return false;
        }
        this.force(false);
        other.force(false);
        UnmodifiableMapCursor cursor = this.cachedValues.getEntries();
        while (cursor.advance()) {
            Object key2 = cursor.getKey();
            if (key2 instanceof Identifier) continue;
            Object value2 = cursor.getValue();
            assert (value2 != null);
            Object otherValue = other.getCachedValue(key2);
            if (value2.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        if (this.cachedHash != 0) {
            return this.cachedHash;
        }
        this.force(false);
        int result = 0;
        UnmodifiableMapCursor cursor = this.cachedValues.getEntries();
        while (cursor.advance()) {
            Object key2 = cursor.getKey();
            if (key2 instanceof Identifier) continue;
            Object value2 = cursor.getValue();
            assert (value2 != null);
            result = 31 * result + value2.hashCode();
        }
        this.cachedHash = result;
        return result;
    }

    private static final class EmptyHolder {
        private static final VmListing EMPTY = new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), EconomicMaps.create(), 0);

        private EmptyHolder() {
        }
    }
}

