/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import org.pkl.core.ast.PklRootNode;
import org.pkl.core.ast.builder.AstBuilder;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.parser.LexParseException;
import org.pkl.core.parser.Parser;
import org.pkl.core.parser.antlr.PklParser;
import org.pkl.core.runtime.MinPklVersionChecker;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

@TruffleLanguage.Registration(id="pkl", name="Pkl", version="0.27.2", characterMimeTypes={"application/x-pkl"}, contextPolicy=TruffleLanguage.ContextPolicy.SHARED)
public final class VmLanguage
extends TruffleLanguage<VmContext> {
    public static final String MIME_TYPE = "application/x-pkl";
    private static final TruffleLanguage.LanguageReference<VmLanguage> REFERENCE = TruffleLanguage.LanguageReference.create(VmLanguage.class);

    public static VmLanguage get(@Nullable Node node) {
        return REFERENCE.get(node);
    }

    @Override
    protected VmContext createContext(TruffleLanguage.Env env) {
        return new VmContext();
    }

    @Override
    public CallTarget parse(TruffleLanguage.ParsingRequest request) {
        throw new UnsupportedOperationException("parse");
    }

    @CompilerDirectives.TruffleBoundary
    public VmTyped loadModule(ModuleKey moduleKey) {
        VmContext context2 = VmContext.get(null);
        return context2.getModuleCache().getOrLoad(moduleKey, context2.getSecurityManager(), context2.getModuleResolver(), VmUtils::createEmptyModule, this::initializeModule, null);
    }

    @CompilerDirectives.TruffleBoundary
    public VmTyped loadModule(ModuleKey moduleKey, @Nullable Node importNode) {
        VmContext context2 = VmContext.get(null);
        return context2.getModuleCache().getOrLoad(moduleKey, context2.getSecurityManager(), context2.getModuleResolver(), VmUtils::createEmptyModule, this::initializeModule, importNode);
    }

    @CompilerDirectives.TruffleBoundary
    void initializeModule(ModuleKey moduleKey, ResolvedModuleKey resolvedModuleKey, ModuleResolver moduleResolver, Source source, VmTyped emptyModule, @Nullable Node importNode) {
        PklParser.ModuleContext moduleContext;
        Parser parser = new Parser();
        try {
            moduleContext = parser.parseModule(source.getCharacters().toString());
        }
        catch (LexParseException e2) {
            String moduleName = IoUtils.inferModuleName(moduleKey);
            MinPklVersionChecker.check(moduleName, e2.getPartialParseResult(), importNode);
            throw VmUtils.toVmException(e2, source, moduleName);
        }
        AstBuilder builder = AstBuilder.create(source, this, moduleContext, moduleKey, resolvedModuleKey, moduleResolver);
        PklRootNode moduleNode = builder.visitModule(moduleContext);
        moduleNode.getCallTarget().call(emptyModule, emptyModule);
        MinPklVersionChecker.check(emptyModule, importNode);
    }
}

