/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Map;
import org.pkl.core.DataSize;
import org.pkl.core.DataSizeUnit;
import org.pkl.core.Value;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.MathUtils;
import org.pkl.core.util.Nullable;

@CompilerDirectives.ValueType
public final class VmDataSize
extends VmValue
implements Comparable<VmDataSize> {
    private static final Map<Identifier, DataSizeUnit> UNITS = Map.ofEntries(Map.entry(Identifier.B, DataSizeUnit.BYTES), Map.entry(Identifier.KB, DataSizeUnit.KILOBYTES), Map.entry(Identifier.KIB, DataSizeUnit.KIBIBYTES), Map.entry(Identifier.MB, DataSizeUnit.MEGABYTES), Map.entry(Identifier.MIB, DataSizeUnit.MEBIBYTES), Map.entry(Identifier.GB, DataSizeUnit.GIGABYTES), Map.entry(Identifier.GIB, DataSizeUnit.GIBIBYTES), Map.entry(Identifier.TB, DataSizeUnit.TERABYTES), Map.entry(Identifier.TIB, DataSizeUnit.TEBIBYTES), Map.entry(Identifier.PB, DataSizeUnit.PETABYTES), Map.entry(Identifier.PIB, DataSizeUnit.PEBIBYTES));
    private final double value;
    private final DataSizeUnit unit;

    public VmDataSize(double value2, DataSizeUnit unit2) {
        this.value = value2;
        this.unit = unit2;
    }

    @Nullable
    public static DataSizeUnit toUnit(Identifier identifier) {
        return UNITS.get(identifier);
    }

    @Override
    public VmClass getVmClass() {
        return BaseModule.getDataSizeClass();
    }

    public double getValue() {
        return this.value;
    }

    public DataSizeUnit getUnit() {
        return this.unit;
    }

    public VmDataSize add(VmDataSize other) {
        if (this.unit.ordinal() <= other.unit.ordinal()) {
            return new VmDataSize(this.convertValueTo(other.unit) + other.value, other.unit);
        }
        return new VmDataSize(this.value + other.convertValueTo(this.unit), this.unit);
    }

    public VmDataSize subtract(VmDataSize other) {
        if (this.unit.ordinal() <= other.unit.ordinal()) {
            return new VmDataSize(this.convertValueTo(other.unit) - other.value, other.unit);
        }
        return new VmDataSize(this.value - other.convertValueTo(this.unit), this.unit);
    }

    public VmDataSize multiply(double num) {
        return new VmDataSize(this.value * num, this.unit);
    }

    public VmDataSize divide(double num) {
        return new VmDataSize(this.value / num, this.unit);
    }

    public double divide(VmDataSize other) {
        if (this.unit.ordinal() <= other.unit.ordinal()) {
            return this.convertValueTo(other.unit) / other.value;
        }
        return this.value / other.convertValueTo(this.unit);
    }

    public VmDataSize remainder(double num) {
        return new VmDataSize(this.value % num, this.unit);
    }

    public VmDataSize pow(double num) {
        return new VmDataSize(StrictMath.pow(this.value, num), this.unit);
    }

    public VmDataSize round() {
        return new VmDataSize(StrictMath.rint(this.value), this.unit);
    }

    public VmDataSize convertTo(DataSizeUnit unit2) {
        return new VmDataSize(this.convertValueTo(unit2), unit2);
    }

    @Override
    public void force(boolean allowUndefinedValues) {
    }

    @Override
    public Value export() {
        return new DataSize(this.value, this.unit);
    }

    @Override
    public void accept(VmValueVisitor visitor) {
        visitor.visitDataSize(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path2) {
        return converter.convertDataSize(this, path2);
    }

    @Override
    public int compareTo(VmDataSize other) {
        if (this.unit.ordinal() <= other.unit.ordinal()) {
            return Double.compare(this.convertValueTo(other.unit), other.value);
        }
        return Double.compare(this.value, other.convertValueTo(this.unit));
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VmDataSize)) {
            return false;
        }
        VmDataSize other = (VmDataSize)obj;
        return this.convertValueTo(DataSizeUnit.BYTES) == other.convertValueTo(DataSizeUnit.BYTES);
    }

    public int hashCode() {
        return Double.hashCode(this.convertValueTo(DataSizeUnit.BYTES));
    }

    public String toString() {
        return MathUtils.isMathematicalInteger(this.value) ? (long)this.value + "." + this.unit : this.value + "." + this.unit;
    }

    private double convertValueTo(DataSizeUnit other) {
        return this.value * (double)this.unit.getBytes() / (double)other.getBytes();
    }
}

