/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pkl.core.BufferedLogger;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.TestResults;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.module.ModuleKeys;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.ModuleInfo;
import org.pkl.core.runtime.TestModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.stdlib.base.PcfRenderer;
import org.pkl.core.util.AnsiStringBuilder;
import org.pkl.core.util.AnsiTheme;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.MutableBoolean;
import org.pkl.core.util.MutableReference;

public final class TestRunner {
    private static final PklConverter converter = new PklConverter(VmMapping.empty());
    private final BufferedLogger logger;
    private final StackFrameTransformer stackFrameTransformer;
    private final boolean overwrite;
    private final boolean useColor;

    public TestRunner(BufferedLogger logger, StackFrameTransformer stackFrameTransformer2, boolean overwrite, boolean useColor2) {
        this.logger = logger;
        this.stackFrameTransformer = stackFrameTransformer2;
        this.overwrite = overwrite;
        this.useColor = useColor2;
    }

    public TestResults run(VmTyped testModule) {
        ModuleInfo info = VmUtils.getModuleInfo(testModule);
        TestResults.Builder resultsBuilder = new TestResults.Builder(info.getModuleName(), TestRunner.getDisplayUri(info));
        try {
            this.checkAmendsPklTest(testModule);
        }
        catch (VmException v) {
            TestResults.Error error = new TestResults.Error(v.getMessage(), v.toPklException(this.stackFrameTransformer, this.useColor));
            return resultsBuilder.setError(error).build();
        }
        resultsBuilder.setFactsSection(this.runFacts(testModule));
        resultsBuilder.setExamplesSection(this.runExamples(testModule, info));
        resultsBuilder.setStdErr(this.logger.getLogs());
        return resultsBuilder.build();
    }

    private void checkAmendsPklTest(VmTyped value2) {
        VmClass testModuleClass = TestModule.getModule().getVmClass();
        VmClass moduleClass = value2.getVmClass();
        while (moduleClass != testModuleClass) {
            if ((moduleClass = moduleClass.getSuperclass()) != null) continue;
            throw new VmExceptionBuilder().typeMismatch(value2, testModuleClass).build();
        }
    }

    private TestResults.TestSectionResults runFacts(VmTyped testModule) {
        Object facts = VmUtils.readMember(testModule, Identifier.FACTS);
        if (facts instanceof VmNull) {
            return new TestResults.TestSectionResults(TestResults.TestSectionName.FACTS, List.of());
        }
        ArrayList testResults = new ArrayList();
        VmMapping factsMapping = (VmMapping)facts;
        factsMapping.forceAndIterateMemberValues((groupKey, groupMember, groupValue) -> {
            VmListing listing = (VmListing)groupValue;
            String name = String.valueOf(groupKey);
            TestResults.TestResult.Builder resultBuilder = new TestResults.TestResult.Builder(name);
            listing.iterateMembers((idx, member) -> {
                if (member.isLocalOrExternalOrHidden()) {
                    return true;
                }
                try {
                    Object factValue = VmUtils.readMember(listing, idx);
                    if (factValue == Boolean.FALSE) {
                        TestResults.Failure failure = this.factFailure(member.getSourceSection(), TestRunner.getDisplayUri(member));
                        resultBuilder.addFailure(failure);
                    } else {
                        resultBuilder.addSuccess();
                    }
                }
                catch (VmException err) {
                    TestResults.Error error = new TestResults.Error(err.getMessage(), err.toPklException(this.stackFrameTransformer, this.useColor));
                    resultBuilder.addError(error);
                }
                return true;
            });
            testResults.add(resultBuilder.build());
            return true;
        });
        return new TestResults.TestSectionResults(TestResults.TestSectionName.FACTS, Collections.unmodifiableList(testResults));
    }

    private TestResults.TestSectionResults runExamples(VmTyped testModule, ModuleInfo info) {
        Object examples = VmUtils.readMember(testModule, Identifier.EXAMPLES);
        if (examples instanceof VmNull) {
            return new TestResults.TestSectionResults(TestResults.TestSectionName.EXAMPLES, List.of());
        }
        URI moduleUri = info.getModuleKey().getUri();
        if (!moduleUri.getScheme().equalsIgnoreCase("file")) {
            throw new VmExceptionBuilder().evalError("cannotEvaluateNonFileBasedTestModule", moduleUri).build();
        }
        VmMapping examplesMapping = (VmMapping)examples;
        Path moduleFile = Path.of(moduleUri);
        Path expectedOutputFile = moduleFile.resolveSibling(moduleFile.getFileName() + "-expected.pcf");
        Path actualOutputFile = moduleFile.resolveSibling(moduleFile.getFileName() + "-actual.pcf");
        try {
            Files.deleteIfExists(actualOutputFile);
        }
        catch (IOException e2) {
            throw new VmExceptionBuilder().evalError("ioErrorWritingTestOutputFile", actualOutputFile).withCause(e2).build();
        }
        try {
            if (this.overwrite) {
                Files.deleteIfExists(expectedOutputFile);
            }
        }
        catch (IOException e3) {
            throw new VmExceptionBuilder().evalError("ioErrorWritingTestOutputFile", expectedOutputFile).withCause(e3).build();
        }
        if (Files.exists(expectedOutputFile, new LinkOption[0])) {
            return this.doRunAndValidateExamples(examplesMapping, expectedOutputFile, actualOutputFile);
        }
        return this.doRunAndWriteExamples(examplesMapping, expectedOutputFile);
    }

    private TestResults.TestSectionResults doRunAndValidateExamples(VmMapping examples, Path expectedOutputFile, Path actualOutputFile) {
        VmDynamic expectedExampleOutputs = this.loadExampleOutputs(expectedOutputFile);
        MutableReference<Object> actualExampleOutputs = new MutableReference<Object>(null);
        MutableBoolean allGroupsSucceeded = new MutableBoolean(true);
        MutableBoolean errored = new MutableBoolean(false);
        ArrayList testResults = new ArrayList();
        examples.forceAndIterateMemberValues((groupKey, groupMember, groupValue) -> {
            String testName = String.valueOf(groupKey);
            VmListing group = (VmListing)groupValue;
            VmDynamic expectedGroup = (VmDynamic)VmUtils.readMemberOrNull(expectedExampleOutputs, groupKey);
            TestResults.TestResult.Builder testResultBuilder = new TestResults.TestResult.Builder(testName);
            if (expectedGroup == null) {
                testResultBuilder.addFailure(this.examplePropertyMismatchFailure(TestRunner.getDisplayUri(groupMember), testName, true));
                testResults.add(testResultBuilder.build());
                return true;
            }
            if (group.getLength() != expectedGroup.getLength()) {
                testResultBuilder.addFailure(this.exampleLengthMismatchFailure(TestRunner.getDisplayUri(groupMember), testName, expectedGroup.getLength(), group.getLength()));
                testResults.add(testResultBuilder.build());
                return true;
            }
            group.iterateMembers((exampleIndex, exampleMember) -> {
                Object exampleValue;
                if (exampleMember.isLocalOrExternalOrHidden()) {
                    return true;
                }
                try {
                    exampleValue = VmUtils.readMember(group, exampleIndex);
                }
                catch (VmException err) {
                    errored.set(true);
                    testResultBuilder.addError(new TestResults.Error(err.getMessage(), err.toPklException(this.stackFrameTransformer, this.useColor)));
                    return true;
                }
                Object expectedValue = VmUtils.readMember(expectedGroup, exampleIndex);
                String exampleValuePcf = TestRunner.renderAsPcf(exampleValue);
                String expectedValuePcf = TestRunner.renderAsPcf(expectedValue);
                if (!exampleValuePcf.equals(expectedValuePcf)) {
                    ObjectMember actualMember;
                    if (actualExampleOutputs.isNull()) {
                        this.writeExampleOutputs(actualOutputFile, examples);
                        actualExampleOutputs.set(this.loadExampleOutputs(actualOutputFile));
                    }
                    ObjectMember expectedMember = VmUtils.findMember(expectedGroup, exampleIndex);
                    assert (expectedMember != null);
                    VmObjectLike actualGroup = (VmObjectLike)VmUtils.readMemberOrNull((VmObjectLike)actualExampleOutputs.get(), groupKey);
                    ObjectMember objectMember = actualMember = actualGroup == null ? null : VmUtils.findMember(actualGroup, exampleIndex);
                    if (actualMember == null) {
                        throw new VmExceptionBuilder().evalError("invalidOutputFileStructure", actualOutputFile).build();
                    }
                    testResultBuilder.addFailure(this.exampleFailure(TestRunner.getDisplayUri(exampleMember), TestRunner.getDisplayUri(expectedMember), expectedValuePcf, TestRunner.getDisplayUri(actualMember), exampleValuePcf, testResultBuilder.getCount()));
                } else {
                    testResultBuilder.addSuccess();
                }
                return true;
            });
            testResults.add(testResultBuilder.build());
            return true;
        });
        expectedExampleOutputs.iterateMembers((groupKey, groupMember) -> {
            if (groupMember.isLocalOrExternalOrHidden()) {
                return true;
            }
            if (examples.getCachedValue(groupKey) == null) {
                String testName = String.valueOf(groupKey);
                allGroupsSucceeded.set(false);
                TestResults.TestResult result = new TestResults.TestResult.Builder(testName).addFailure(this.examplePropertyMismatchFailure(TestRunner.getDisplayUri(groupMember), testName, false)).build();
                testResults.add(result);
            }
            return true;
        });
        if (!allGroupsSucceeded.get() && actualExampleOutputs.isNull() && !errored.get()) {
            this.writeExampleOutputs(actualOutputFile, examples);
        }
        return new TestResults.TestSectionResults(TestResults.TestSectionName.EXAMPLES, Collections.unmodifiableList(testResults));
    }

    private TestResults.TestSectionResults doRunAndWriteExamples(VmMapping examples, Path outputFile) {
        ArrayList testResults = new ArrayList();
        MutableBoolean allSucceeded = new MutableBoolean(true);
        examples.forceAndIterateMemberValues((groupKey, groupMember, groupValue) -> {
            String testName = String.valueOf(groupKey);
            VmListing listing = (VmListing)groupValue;
            TestResults.TestResult.Builder testResultBuilder = new TestResults.TestResult.Builder(testName);
            MutableBoolean success = new MutableBoolean(true);
            listing.iterateMembers((idx, member) -> {
                if (member.isLocalOrExternalOrHidden()) {
                    return true;
                }
                try {
                    VmUtils.readMember(listing, idx);
                    return true;
                }
                catch (VmException err) {
                    testResultBuilder.addError(new TestResults.Error(err.getMessage(), err.toPklException(this.stackFrameTransformer, this.useColor)));
                    allSucceeded.set(false);
                    success.set(false);
                    return true;
                }
            });
            if (success.get()) {
                testResultBuilder.setExampleWritten(true);
                testResultBuilder.addFailure(this.writtenExampleOutputFailure(testName, TestRunner.getDisplayUri(groupMember)));
            }
            testResults.add(testResultBuilder.build());
            return true;
        });
        if (allSucceeded.get()) {
            this.writeExampleOutputs(outputFile, examples);
        }
        return new TestResults.TestSectionResults(TestResults.TestSectionName.EXAMPLES, Collections.unmodifiableList(testResults));
    }

    private void writeExampleOutputs(Path outputFile, VmMapping examples) {
        VmDynamic outputFileContent = new VmDynamic(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getDynamicClass().getPrototype(), EconomicMaps.of(Identifier.EXAMPLES, VmUtils.createSyntheticObjectProperty(Identifier.EXAMPLES, "examples", examples)), 0);
        StringBuilder builder = new StringBuilder();
        new PcfRenderer(builder, "  ", converter, false, true).renderDocument(outputFileContent);
        try {
            Files.writeString(outputFile, (CharSequence)builder, new OpenOption[0]);
        }
        catch (IOException e2) {
            throw new VmExceptionBuilder().evalError("ioErrorWritingTestOutputFile", outputFile).withCause(e2).build();
        }
    }

    private VmDynamic loadExampleOutputs(Path outputFile) {
        String fileContent;
        try {
            fileContent = Files.readString(outputFile, StandardCharsets.UTF_8);
        }
        catch (IOException e2) {
            throw new VmExceptionBuilder().evalError("ioErrorReadingTestOutputFile", outputFile).withCause(e2).build();
        }
        VmTyped module = VmLanguage.get(null).loadModule(ModuleKeys.synthetic(outputFile.toUri(), fileContent));
        VmDynamic examples = (VmDynamic)VmUtils.readMemberOrNull(module, Identifier.EXAMPLES);
        if (examples == null) {
            throw new VmExceptionBuilder().evalError("invalidOutputFileStructure", outputFile).build();
        }
        return examples;
    }

    private static String renderAsPcf(Object pklValue) {
        StringBuilder builder = new StringBuilder();
        new PcfRenderer(builder, "  ", converter, false, false).renderValue(pklValue);
        if (pklValue instanceof VmObject) {
            builder.insert(0, "new ");
        }
        return builder.toString();
    }

    private static String getDisplayUri(ObjectMember member) {
        return VmUtils.getDisplayUri(member.getSourceSection(), VmContext.get(null).getFrameTransformer());
    }

    private static String getDisplayUri(ModuleInfo moduleInfo) {
        return VmUtils.getDisplayUri(moduleInfo.getModuleKey().getUri(), VmContext.get(null).getFrameTransformer());
    }

    private TestResults.Failure factFailure(SourceSection sourceSection, String location) {
        AnsiStringBuilder sb = new AnsiStringBuilder(this.useColor);
        sb.append(AnsiTheme.TEST_FACT_SOURCE, sourceSection.getCharacters().toString()).append(" ");
        this.appendLocation(sb, location);
        return new TestResults.Failure("Fact Failure", sb.toString());
    }

    private TestResults.Failure exampleLengthMismatchFailure(String location, String property, int expectedLength, int actualLength) {
        AnsiStringBuilder sb = new AnsiStringBuilder(this.useColor);
        this.appendLocation(sb, location);
        sb.append('\n').append(AnsiTheme.TEST_FAILURE_MESSAGE, () -> sb.append("Output mismatch: Expected \"").append(property).append("\" to contain ").append(expectedLength).append(" examples, but found ").append(actualLength));
        return new TestResults.Failure("Output Mismatch (Length)", sb.toString());
    }

    private TestResults.Failure examplePropertyMismatchFailure(String location, String property, boolean isMissingInExpected) {
        String missingIn;
        String existsIn;
        if (isMissingInExpected) {
            existsIn = "actual";
            missingIn = "expected";
        } else {
            existsIn = "expected";
            missingIn = "actual";
        }
        AnsiStringBuilder sb = new AnsiStringBuilder(this.useColor);
        this.appendLocation(sb, location);
        sb.append('\n').append(AnsiTheme.TEST_FAILURE_MESSAGE, () -> sb.append("Output mismatch: \"").append(property).append("\" exists in ").append(existsIn).append(" but not in ").append(missingIn).append(" output"));
        return new TestResults.Failure("Output Mismatch", sb.toString());
    }

    private TestResults.Failure exampleFailure(String location, String expectedLocation, String expectedValue, String actualLocation, String actualValue, int exampleNumber) {
        AnsiStringBuilder sb = new AnsiStringBuilder(this.useColor);
        sb.append(AnsiTheme.TEST_NAME, "#" + exampleNumber + ": ");
        sb.append(AnsiTheme.TEST_FAILURE_MESSAGE, () -> {
            this.appendLocation(sb, location);
            sb.append("\n  Expected: ");
            this.appendLocation(sb, expectedLocation);
            sb.append("\n  ");
            sb.append(AnsiTheme.TEST_EXAMPLE_OUTPUT, expectedValue.replaceAll("\n", "\n  "));
            sb.append("\n  Actual: ");
            this.appendLocation(sb, actualLocation);
            sb.append("\n  ");
            sb.append(AnsiTheme.TEST_EXAMPLE_OUTPUT, actualValue.replaceAll("\n", "\n  "));
        });
        return new TestResults.Failure("Example Failure", sb.toString());
    }

    private void appendLocation(AnsiStringBuilder stringBuilder, String location) {
        stringBuilder.append(AnsiTheme.STACK_FRAME, () -> stringBuilder.append("(").appendUntrusted(location).append(")"));
    }

    private TestResults.Failure writtenExampleOutputFailure(String testName, String location) {
        AnsiStringBuilder sb = new AnsiStringBuilder(this.useColor);
        this.appendLocation(sb, location);
        sb.append(AnsiTheme.TEST_FAILURE_MESSAGE, "\nWrote expected output for test ").append(testName);
        return new TestResults.Failure("Example Output Written", sb.toString());
    }
}

