/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.pkl.core.StackFrame;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.AnsiStringBuilder;
import org.pkl.core.util.AnsiTheme;
import org.pkl.core.util.Nullable;

public final class StackTraceRenderer {
    private final Function<StackFrame, StackFrame> frameTransformer;

    public StackTraceRenderer(Function<StackFrame, StackFrame> frameTransformer) {
        this.frameTransformer = frameTransformer;
    }

    public void render(List<StackFrame> frames, @Nullable String hint, AnsiStringBuilder out2) {
        List<Object> compressed = StackTraceRenderer.compressFrames(frames);
        this.doRender(compressed, hint, out2, "", true);
    }

    void doRender(List<Object> frames, @Nullable String hint, AnsiStringBuilder out2, String leftMargin, boolean isFirstElement) {
        for (Object frame : frames) {
            if (frame instanceof StackFrameLoop) {
                StackFrameLoop loop = (StackFrameLoop)frame;
                if (loop.count == 1) {
                    this.doRender(loop.frames, null, out2, leftMargin, isFirstElement);
                } else {
                    if (!isFirstElement) {
                        out2.append(AnsiTheme.STACK_TRACE_MARGIN, leftMargin).append('\n');
                    }
                    out2.append(AnsiTheme.STACK_TRACE_MARGIN, leftMargin).append(AnsiTheme.STACK_TRACE_MARGIN, "\u250c\u2500 ").append(AnsiTheme.STACK_TRACE_LOOP_COUNT, loop.count).append(" repetitions of:\n");
                    String newLeftMargin = leftMargin + "\u2502 ";
                    this.doRender(loop.frames, null, out2, newLeftMargin, isFirstElement);
                    if (isFirstElement) {
                        this.renderHint(hint, out2, newLeftMargin);
                        isFirstElement = false;
                    }
                    out2.append(AnsiTheme.STACK_TRACE_MARGIN, leftMargin + "\u2514\u2500").append('\n');
                }
            } else {
                if (!isFirstElement) {
                    out2.append(AnsiTheme.STACK_TRACE_MARGIN, leftMargin).append('\n');
                }
                this.renderFrame((StackFrame)frame, out2, leftMargin);
            }
            if (!isFirstElement) continue;
            this.renderHint(hint, out2, leftMargin);
            isFirstElement = false;
        }
    }

    private void renderFrame(StackFrame frame, AnsiStringBuilder out2, String leftMargin) {
        StackFrame transformed = this.frameTransformer.apply(frame);
        this.renderSourceLine(transformed, out2, leftMargin);
        this.renderSourceLocation(transformed, out2, leftMargin);
    }

    private void renderHint(@Nullable String hint, AnsiStringBuilder out2, String leftMargin) {
        if (hint == null || hint.isEmpty()) {
            return;
        }
        out2.append('\n').append(AnsiTheme.STACK_TRACE_MARGIN, leftMargin).append(AnsiTheme.ERROR_MESSAGE_HINT, hint).append('\n');
    }

    private void renderSourceLine(StackFrame frame, AnsiStringBuilder out2, String leftMargin) {
        String originalSourceLine = frame.getSourceLines().get(0);
        int leadingWhitespace = VmUtils.countLeadingWhitespace(originalSourceLine);
        String sourceLine = originalSourceLine.strip();
        int startColumn = frame.getStartColumn() - leadingWhitespace;
        int endColumn = frame.getStartLine() == frame.getEndLine() ? frame.getEndColumn() - leadingWhitespace : sourceLine.length();
        String prefix = frame.getStartLine() + " | ";
        out2.append(AnsiTheme.STACK_TRACE_MARGIN, leftMargin).append(AnsiTheme.STACK_TRACE_LINE_NUMBER, prefix).append(sourceLine).append('\n').append(AnsiTheme.STACK_TRACE_MARGIN, leftMargin).append(" ".repeat(prefix.length() + startColumn - 1)).append(AnsiTheme.STACK_TRACE_CARET, "^".repeat(endColumn - startColumn + 1)).append('\n');
    }

    private void renderSourceLocation(StackFrame frame, AnsiStringBuilder out2, String leftMargin) {
        out2.append(AnsiTheme.STACK_TRACE_MARGIN, leftMargin).append(AnsiTheme.STACK_FRAME, () -> out2.append("at ").append(frame.getMemberName() != null ? frame.getMemberName() : "<unknown>").append(" (").appendUntrusted(frame.getModuleUri()).append(")").append('\n'));
    }

    static List<Object> compressFrames(List<StackFrame> frames) {
        return StackTraceRenderer.doCompressFrames(frames, new int[frames.size()], new ArrayList<Object>(), 0, frames.size());
    }

    private static List<Object> doCompressFrames(List<StackFrame> frames, int[] lpps, List<Object> result, int beginning, int ending) {
        int i;
        int framesLastIndex = frames.size() - 1;
        int totalSize = ending - beginning;
        int maxLength = -1;
        int patternStart = -2;
        int patternWidth = -2;
        int matchEnd = -2;
        block0: for (i = beginning; i < ending; ++i) {
            int best = i;
            int len = 0;
            lpps[i] = 0;
            int j = i + 1;
            while (j < ending) {
                StackFrame frame2;
                StackFrame frame1 = frames.get(framesLastIndex - j);
                boolean match = frame1.equals(frame2 = frames.get(framesLastIndex - (len + i)));
                if (!match && len != 0) {
                    len = lpps[len - 1];
                    continue;
                }
                lpps[j] = len += match ? 1 : 0;
                if (len > lpps[best]) {
                    best = j;
                } else if (len > 0 && len == lpps[j - 1]) continue block0;
                ++j;
            }
            int length2 = best - i + 1;
            if (length2 > 1 && maxLength < length2) {
                maxLength = length2;
                matchEnd = best;
                patternStart = i;
            }
            if (maxLength > ending - i || maxLength * 2 > totalSize) break;
        }
        if (maxLength > 1) {
            patternWidth = matchEnd - lpps[matchEnd] - patternStart + 1;
            StackTraceRenderer.doCompressFrames(frames, lpps, result, matchEnd + 1, ending);
            result.add(new StackFrameLoop(StackTraceRenderer.doCompressFrames(frames, lpps, new ArrayList<Object>(), patternStart, patternStart + patternWidth), maxLength / patternWidth));
            StackTraceRenderer.doCompressFrames(frames, lpps, result, beginning, patternStart);
        } else {
            for (i = ending - 1; i >= beginning; --i) {
                result.add(frames.get(framesLastIndex - i));
            }
        }
        return result;
    }

    static class StackFrameLoop {
        final List<Object> frames;
        final int count;

        StackFrameLoop(List<Object> frames, int count2) {
            this.count = count2;
            this.frames = frames;
        }
    }
}

