/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.parser;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.Vocabulary;
import org.pkl.core.parser.LexParseException;
import org.pkl.core.parser.antlr.PklLexer;
import org.pkl.core.util.Nullable;

public final class Lexer {
    public static final Set<Integer> KEYWORD_TYPES;
    public static final Set<String> KEYWORD_NAMES;

    @CompilerDirectives.TruffleBoundary
    public static PklLexer createLexer(CharStream source) {
        PklLexer lexer = new PklLexer(source);
        lexer.removeErrorListeners();
        lexer.addErrorListener(new ANTLRErrorListener<Integer>(){

            @Override
            public <T extends Integer> void syntaxError(Recognizer<T, ?> recognizer, T offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e2) {
                org.antlr.v4.runtime.Lexer lexer = (org.antlr.v4.runtime.Lexer)recognizer;
                throw new LexParseException.LexError(msg, line, charPositionInLine + 1, lexer._input.index() - lexer._tokenStartCharIndex);
            }
        });
        return lexer;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isKeyword(@Nullable Token token) {
        return token != null && KEYWORD_TYPES.contains(token.getType());
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isRegularIdentifier(String identifier) {
        if (identifier.isEmpty()) {
            return false;
        }
        if (KEYWORD_NAMES.contains(identifier)) {
            return false;
        }
        int firstCp = identifier.codePointAt(0);
        return (firstCp == 36 || firstCp == 95 || Character.isUnicodeIdentifierStart(firstCp)) && identifier.codePoints().skip(1L).allMatch(cp -> cp == 36 || Character.isUnicodeIdentifierPart(cp));
    }

    @CompilerDirectives.TruffleBoundary
    public static String maybeQuoteIdentifier(String identifier) {
        return Lexer.isRegularIdentifier(identifier) ? identifier : "`" + identifier + "`";
    }

    static {
        HashSet<Integer> keywordTypes = new HashSet<Integer>();
        HashSet<String> keywordNames = new HashSet<String>();
        Vocabulary vocabulary = PklLexer.VOCABULARY;
        for (int i = 0; i <= vocabulary.getMaxTokenType(); ++i) {
            String literal = vocabulary.getLiteralName(i);
            if (literal == null || !Character.isLetter((literal = literal.substring(1, literal.length() - 1)).charAt(0)) && !literal.equals("_")) continue;
            keywordTypes.add(i);
            keywordNames.add(literal);
        }
        KEYWORD_TYPES = Collections.unmodifiableSet(keywordTypes);
        KEYWORD_NAMES = Collections.unmodifiableSet(keywordNames);
    }
}

