/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.packages;

import java.net.URISyntaxException;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.json.Json;

public final class PackageUtils {
    private PackageUtils() {
    }

    public static PackageUri parsePackageUriWithoutChecksums(Object obj) throws Json.JsonParseException, URISyntaxException {
        if (!(obj instanceof String)) {
            throw new Json.FormatException("string", obj.getClass());
        }
        String string = (String)obj;
        PackageUri packageUri = new PackageUri(string);
        PackageUtils.checkHasNoChecksumComponent(packageUri);
        return packageUri;
    }

    public static void checkHasNoChecksumComponent(PackageUri packageUri) throws URISyntaxException {
        if (packageUri.getChecksums() != null) {
            throw new URISyntaxException(packageUri.toString(), ErrorMessages.create("unexpectedChecksumInPackageUri", new Object[0]));
        }
    }
}

