/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.module;

import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pkl.core.module.PathElement;
import org.pkl.core.util.IoUtils;

public final class FileResolver {
    private FileResolver() {
    }

    public static List<PathElement> listElements(URI baseUri) throws IOException {
        return FileResolver.listElements(IoUtils.pathOf(baseUri));
    }

    public static List<PathElement> listElements(Path path2) throws IOException {
        ArrayList<PathElement> arrayList;
        block9: {
            DirectoryStream<Path> stream = Files.newDirectoryStream(path2);
            try {
                ArrayList<PathElement> ret = new ArrayList<PathElement>();
                for (Path entry : stream) {
                    if (Files.isSymbolicLink(entry)) continue;
                    ret.add(new PathElement(entry.getFileName().toString(), Files.isDirectory(entry, new LinkOption[0])));
                }
                arrayList = ret;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException | NotDirectoryException ignored) {
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return arrayList;
    }

    public static boolean hasElement(URI elementUri) {
        return Files.exists(IoUtils.pathOf(elementUri), new LinkOption[0]);
    }

    public static boolean hasElement(Path path2) {
        return Files.exists(path2, new LinkOption[0]);
    }
}

