/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.messaging;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.pkl.core.messaging.Message;
import org.pkl.core.messaging.MessageDecoder;
import org.pkl.core.messaging.MessageEncoder;
import org.pkl.core.messaging.MessageTransport;
import org.pkl.core.messaging.ProtocolException;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.Pair;

public final class MessageTransports {
    private MessageTransports() {
    }

    public static MessageTransport stream(MessageDecoder decoder, MessageEncoder encoder, Logger logger) {
        return new EncodingMessageTransport(decoder, encoder, logger);
    }

    public static Pair<MessageTransport, MessageTransport> direct(Logger logger) {
        DirectMessageTransport transport1 = new DirectMessageTransport(logger);
        DirectMessageTransport transport2 = new DirectMessageTransport(logger);
        transport1.setOther(transport2);
        transport2.setOther(transport1);
        return Pair.of(transport1, transport2);
    }

    public static <T> T resolveFuture(Future<T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e2) {
            Throwable throwable = e2.getCause();
            if (throwable instanceof IOException) {
                IOException ioExc = (IOException)throwable;
                throw ioExc;
            }
            throw new IOException("external read failure: " + e2.getMessage(), e2.getCause());
        }
    }

    protected static class EncodingMessageTransport
    extends AbstractMessageTransport {
        private final MessageDecoder decoder;
        private final MessageEncoder encoder;
        private volatile boolean isClosed = false;

        protected EncodingMessageTransport(MessageDecoder decoder, MessageEncoder encoder, Logger logger) {
            super(logger);
            this.decoder = decoder;
            this.encoder = encoder;
        }

        @Override
        protected void doStart() throws ProtocolException, IOException {
            while (!this.isClosed) {
                Message message = this.decoder.decode();
                if (message == null) {
                    return;
                }
                this.accept(message);
            }
        }

        @Override
        protected void doClose() {
            this.isClosed = true;
        }

        @Override
        protected void doSend(Message message) throws ProtocolException, IOException {
            this.encoder.encode(message);
        }
    }

    public static interface Logger {
        public void log(String var1);
    }

    protected static class DirectMessageTransport
    extends AbstractMessageTransport {
        private DirectMessageTransport other;

        protected DirectMessageTransport(Logger logger) {
            super(logger);
        }

        @Override
        protected void doStart() {
        }

        @Override
        protected void doClose() {
        }

        @Override
        protected void doSend(Message message) throws ProtocolException, IOException {
            this.other.accept(message);
        }

        public void setOther(DirectMessageTransport other) {
            this.other = other;
        }
    }

    protected static abstract class AbstractMessageTransport
    implements MessageTransport {
        private final Logger logger;
        private MessageTransport.OneWayHandler oneWayHandler;
        private MessageTransport.RequestHandler requestHandler;
        private final Map<Long, MessageTransport.ResponseHandler> responseHandlers = new ConcurrentHashMap<Long, MessageTransport.ResponseHandler>();

        protected AbstractMessageTransport(Logger logger) {
            this.logger = logger;
        }

        protected void log(String message, Object ... args2) {
            MessageFormat formatter = new MessageFormat(message);
            this.logger.log(formatter.format(args2));
        }

        protected abstract void doStart() throws ProtocolException, IOException;

        protected abstract void doClose();

        protected abstract void doSend(Message var1) throws ProtocolException, IOException;

        protected void accept(Message message) throws ProtocolException, IOException {
            this.log("Received message: {0}", message);
            if (message instanceof Message.OneWay) {
                Message.OneWay msg = (Message.OneWay)message;
                this.oneWayHandler.handleOneWay(msg);
            } else if (message instanceof Message.Request) {
                Message.Request msg = (Message.Request)message;
                this.requestHandler.handleRequest(msg);
            } else if (message instanceof Message.Response) {
                Message.Response msg = (Message.Response)message;
                MessageTransport.ResponseHandler handler = this.responseHandlers.remove(msg.requestId());
                if (handler == null) {
                    throw new ProtocolException(ErrorMessages.create("unknownRequestId", message.getClass().getSimpleName(), msg.requestId()));
                }
                handler.handleResponse(msg);
            }
        }

        @Override
        public final void start(MessageTransport.OneWayHandler oneWayHandler, MessageTransport.RequestHandler requestHandler) throws ProtocolException, IOException {
            this.log("Starting transport: {0}", this);
            this.oneWayHandler = oneWayHandler;
            this.requestHandler = requestHandler;
            this.doStart();
        }

        @Override
        public final void close() {
            this.log("Closing transport: {0}", this);
            this.doClose();
            this.responseHandlers.clear();
        }

        @Override
        public void send(Message.OneWay message) throws ProtocolException, IOException {
            this.log("Sending message: {0}", message);
            this.doSend(message);
        }

        @Override
        public void send(Message.Request message, MessageTransport.ResponseHandler responseHandler) throws ProtocolException, IOException {
            this.log("Sending message: {0}", message);
            this.responseHandlers.put(message.requestId(), responseHandler);
            this.doSend(message);
        }

        @Override
        public void send(Message.Response message) throws ProtocolException, IOException {
            this.log("Sending message: {0}", message);
            this.doSend(message);
        }
    }
}

