/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.util.Nullable;

@NodeInfo(shortName="is")
public final class TypeTestNode
extends ExpressionNode {
    @Node.Child
    private ExpressionNode valueNode;
    @Node.Child
    private UnresolvedTypeNode unresolvedTypeNode;
    @Node.Child
    @Nullable
    private TypeNode typeNode;

    public TypeTestNode(SourceSection sourceSection, ExpressionNode valueNode, UnresolvedTypeNode unresolvedTypeNode) {
        super(sourceSection);
        this.valueNode = valueNode;
        this.unresolvedTypeNode = unresolvedTypeNode;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) {
        if (this.typeNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.typeNode = this.insert(this.unresolvedTypeNode.execute(frame));
            this.unresolvedTypeNode = null;
        }
        Object value2 = this.valueNode.executeGeneric(frame);
        try {
            this.typeNode.executeEagerly(frame, value2);
            return true;
        }
        catch (VmTypeMismatchException e2) {
            return false;
        }
    }
}

