/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.PklRootNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.util.Nullable;

public final class IdentityMixinNode
extends PklRootNode {
    private final SourceSection sourceSection;
    private final String qualifiedName;
    @Node.Child
    @Nullable
    private TypeNode argumentTypeNode;

    public IdentityMixinNode(VmLanguage language, FrameDescriptor descriptor, SourceSection sourceSection, String qualifiedName, @Nullable TypeNode argumentTypeNode) {
        super(language, descriptor);
        this.qualifiedName = qualifiedName;
        this.sourceSection = sourceSection;
        this.argumentTypeNode = argumentTypeNode;
    }

    @Override
    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    @Override
    public String getName() {
        return this.qualifiedName;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        if (arguments.length != 4) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("wrongFunctionArgumentCount", 1, arguments.length - 3).withSourceSection(this.sourceSection).build();
        }
        try {
            Object argument2 = arguments[3];
            if (this.argumentTypeNode != null) {
                return this.argumentTypeNode.execute(frame, argument2);
            }
            return argument2;
        }
        catch (VmTypeMismatchException e2) {
            CompilerDirectives.transferToInterpreter();
            throw e2.toVmException();
        }
        catch (Exception e3) {
            CompilerDirectives.transferToInterpreter();
            if (e3 instanceof VmException) {
                throw e3;
            }
            throw this.exceptionBuilder().bug(e3.getMessage(), new Object[0]).withCause(e3).build();
        }
    }
}

