/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.runtime.VmObjectLike;

public final class InvokeMethodDirectNode
extends ExpressionNode {
    private final VmObjectLike owner;
    @Node.Child
    private ExpressionNode receiverNode;
    @Node.Children
    private final ExpressionNode[] argumentNodes;
    private final boolean isInIterable;
    @Node.Child
    private DirectCallNode callNode;

    public InvokeMethodDirectNode(SourceSection sourceSection, ClassMethod method, ExpressionNode receiverNode, ExpressionNode[] argumentNodes, boolean isInIterable) {
        super(sourceSection);
        this.owner = method.getOwner();
        this.receiverNode = receiverNode;
        this.argumentNodes = argumentNodes;
        this.isInIterable = isInIterable;
        this.callNode = DirectCallNode.create(method.getCallTarget(sourceSection));
    }

    @Override
    @ExplodeLoop
    public Object executeGeneric(VirtualFrame frame) {
        Object[] args2 = new Object[3 + this.argumentNodes.length];
        args2[0] = this.receiverNode.executeGeneric(frame);
        args2[1] = this.owner;
        args2[2] = this.isInIterable;
        for (int i = 0; i < this.argumentNodes.length; ++i) {
            args2[3 + i] = this.argumentNodes[i].executeGeneric(frame);
        }
        return this.callNode.call(args2);
    }
}

