/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.generator;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.expression.generator.GeneratorMemberNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.EconomicMaps;

@ImportStatic(value={BaseModule.class})
public abstract class GeneratorEntryNode
extends GeneratorMemberNode {
    @Node.Child
    private ExpressionNode keyNode;
    private final ObjectMember member;

    protected GeneratorEntryNode(ExpressionNode keyNode, ObjectMember member) {
        super(member.getSourceSection());
        this.keyNode = keyNode;
        this.member = member;
    }

    @Specialization
    protected void evalDynamic(VirtualFrame frame, VmDynamic parent, GeneratorMemberNode.ObjectData data) {
        this.addRegularEntry(frame, data);
    }

    @Specialization
    protected void evalMapping(VirtualFrame frame, VmMapping parent, GeneratorMemberNode.ObjectData data) {
        this.addRegularEntry(frame, data);
    }

    @Specialization
    protected void evalListing(VirtualFrame frame, VmListing parent, GeneratorMemberNode.ObjectData data) {
        this.addListingEntry(frame, data, parent.getLength());
    }

    @Specialization(guards={"parent == getDynamicClass()"})
    protected void evalDynamicClass(VirtualFrame frame, VmClass parent, GeneratorMemberNode.ObjectData data) {
        this.addRegularEntry(frame, data);
    }

    @Specialization(guards={"parent == getMappingClass()"})
    protected void evalMappingClass(VirtualFrame frame, VmClass parent, GeneratorMemberNode.ObjectData data) {
        this.addRegularEntry(frame, data);
    }

    @Specialization(guards={"parent == getListingClass()"})
    protected void evalListingClass(VirtualFrame frame, VmClass parent, GeneratorMemberNode.ObjectData data) {
        this.addListingEntry(frame, data, 0);
    }

    @Fallback
    void fallback(Object parent, GeneratorMemberNode.ObjectData data) {
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().evalError("objectCannotHaveEntry", parent).build();
    }

    private void addRegularEntry(VirtualFrame frame, GeneratorMemberNode.ObjectData data) {
        Object key2 = this.keyNode.executeGeneric(frame);
        this.doAdd(key2, data);
    }

    private void addListingEntry(VirtualFrame frame, GeneratorMemberNode.ObjectData data, int parentLength) {
        long index;
        try {
            index = this.keyNode.executeInt(frame);
        }
        catch (UnexpectedResultException e2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("wrongListingKeyType", new VmException.ProgramValue("", VmUtils.getClass(e2.getResult()))).withLocation(this.keyNode).build();
        }
        if (index < 0L || index >= (long)parentLength) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("elementIndexOutOfRange", index, 0, parentLength - 1).withLocation(this.keyNode).build();
        }
        this.doAdd(index, data);
    }

    private void doAdd(Object key2, GeneratorMemberNode.ObjectData data) {
        if (EconomicMaps.put(data.members, key2, this.member) != null) {
            CompilerDirectives.transferToInterpreter();
            throw this.duplicateDefinition(key2, this.member);
        }
        data.persistForBindings(key2);
    }
}

