/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.binary;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.expression.binary.BinaryExpressionNode;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmSafeMath;

@NodeInfo(shortName="**")
public abstract class ExponentiationNode
extends BinaryExpressionNode {
    public ExponentiationNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    @Specialization(guards={"y >= 0"})
    protected long evalPositive(long x, long y) {
        return VmSafeMath.pow(x, y);
    }

    @Specialization(guards={"y < 0"})
    protected double evalNegative(long x, long y) {
        return StrictMath.pow(x, y);
    }

    @Specialization
    protected double eval(long x, double y) {
        return StrictMath.pow(x, y);
    }

    @Specialization
    protected double eval(double x, long y) {
        return StrictMath.pow(x, y);
    }

    @Specialization
    protected double eval(double x, double y) {
        return StrictMath.pow(x, y);
    }

    @Specialization
    protected VmDuration eval(VmDuration x, long y) {
        return x.pow(y);
    }

    @Specialization
    protected VmDuration eval(VmDuration x, double y) {
        return x.pow(y);
    }

    @Specialization
    protected VmDataSize eval(VmDataSize x, long y) {
        return x.pow(y);
    }

    @Specialization
    protected VmDataSize eval(VmDataSize x, double y) {
        return x.pow(y);
    }
}

