/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.pkl.core.DataSize;
import org.pkl.core.Duration;
import org.pkl.core.PClass;
import org.pkl.core.PModule;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.Pair;
import org.pkl.core.RendererException;
import org.pkl.core.TypeAlias;
import org.pkl.core.ValueRenderer;
import org.pkl.core.ValueVisitor;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.yaml.snake.YamlUtils;
import org.snakeyaml.engine.v2.api.DumpSettings;
import org.snakeyaml.engine.v2.api.StreamDataWriter;
import org.snakeyaml.engine.v2.common.FlowStyle;
import org.snakeyaml.engine.v2.emitter.Emitter;
import org.snakeyaml.engine.v2.events.DocumentEndEvent;
import org.snakeyaml.engine.v2.events.DocumentStartEvent;
import org.snakeyaml.engine.v2.events.MappingEndEvent;
import org.snakeyaml.engine.v2.events.MappingStartEvent;
import org.snakeyaml.engine.v2.events.SequenceEndEvent;
import org.snakeyaml.engine.v2.events.SequenceStartEvent;
import org.snakeyaml.engine.v2.events.StreamEndEvent;
import org.snakeyaml.engine.v2.events.StreamStartEvent;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.resolver.ScalarResolver;

final class YamlRenderer
implements ValueRenderer {
    private final ScalarResolver resolver = YamlUtils.getEmitterResolver("compat");
    private final Visitor visitor = new Visitor();
    private final Emitter emitter;
    private final boolean omitNullProperties;
    private final boolean isStream;

    public YamlRenderer(final Writer writer, int indent, boolean omitNullProperties, boolean isStream) {
        DumpSettings dumpSettings = DumpSettings.builder().setIndent(indent).setBestLineBreak("\n").setScalarResolver(this.resolver).build();
        this.emitter = new Emitter(dumpSettings, new StreamDataWriter(){

            @Override
            public void write(String str) {
                try {
                    writer.write(str);
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }

            @Override
            public void write(String str, int off, int len) {
                try {
                    writer.write(str, off, len);
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }
        });
        this.omitNullProperties = omitNullProperties;
        this.isStream = isStream;
    }

    @Override
    public void renderDocument(Object value2) {
        if (this.isStream) {
            if (!(value2 instanceof Iterable)) {
                throw new RendererException(String.format("The top-level value of a YAML stream must have type `Collection`, but got type `%s`.", value2.getClass().getTypeName()));
            }
            Iterable iterable = (Iterable)value2;
            this.emitter.emit(new StreamStartEvent());
            for (Object elem : iterable) {
                this.emitter.emit(new DocumentStartEvent(false, Optional.empty(), Map.of()));
                this.visitor.visit(elem);
                this.emitter.emit(new DocumentEndEvent(false));
            }
            this.emitter.emit(new StreamEndEvent());
        } else {
            this.renderValue(value2);
        }
    }

    @Override
    public void renderValue(Object value2) {
        this.emitter.emit(new StreamStartEvent());
        this.emitter.emit(new DocumentStartEvent(false, Optional.empty(), Map.of()));
        this.visitor.visit(value2);
        this.emitter.emit(new DocumentEndEvent(false));
        this.emitter.emit(new StreamEndEvent());
    }

    protected class Visitor
    implements ValueVisitor {
        protected Visitor() {
        }

        @Override
        public void visitString(String value2) {
            YamlRenderer.this.emitter.emit(YamlUtils.stringScalar(value2, YamlRenderer.this.resolver));
        }

        @Override
        public void visitInt(Long value2) {
            YamlRenderer.this.emitter.emit(YamlUtils.plainScalar(value2.toString(), Tag.INT));
        }

        @Override
        public void visitFloat(Double value2) {
            YamlRenderer.this.emitter.emit(YamlUtils.plainScalar(value2.toString(), Tag.FLOAT));
        }

        @Override
        public void visitBoolean(Boolean value2) {
            YamlRenderer.this.emitter.emit(YamlUtils.plainScalar(value2.toString(), Tag.BOOL));
        }

        @Override
        public void visitDuration(Duration value2) {
            throw new RendererException(String.format("Values of type `Duration` cannot be rendered as YAML. Value: %s", value2));
        }

        @Override
        public void visitDataSize(DataSize value2) {
            throw new RendererException(String.format("Values of type `DataSize` cannot be rendered as YAML. Value: %s", value2));
        }

        @Override
        public void visitPair(Pair<?, ?> value2) {
            this.doVisitIterable(value2, null);
        }

        @Override
        public void visitList(List<?> value2) {
            this.doVisitIterable(value2, null);
        }

        @Override
        public void visitSet(Set<?> value2) {
            this.doVisitIterable(value2, "!!set");
        }

        @Override
        public void visitMap(Map<?, ?> value2) {
            for (Object key2 : value2.keySet()) {
                if (key2 instanceof String) continue;
                throw new RendererException(String.format("Maps with non-String keys cannot currently be rendered as YAML. Key: %s", key2));
            }
            Map<?, ?> mapValue = value2;
            this.doVisitProperties(mapValue);
        }

        @Override
        public void visitObject(PObject value2) {
            this.doVisitProperties(value2.getProperties());
        }

        @Override
        public void visitModule(PModule value2) {
            this.doVisitProperties(value2.getProperties());
        }

        @Override
        public void visitClass(PClass value2) {
            throw new RendererException(String.format("Values of type `Class` cannot be rendered as YAML. Value: %s", value2.getSimpleName()));
        }

        @Override
        public void visitTypeAlias(TypeAlias value2) {
            throw new RendererException(String.format("Values of type `TypeAlias` cannot be rendered as YAML. Value: %s", value2.getSimpleName()));
        }

        @Override
        public void visitNull() {
            YamlRenderer.this.emitter.emit(YamlUtils.plainScalar("null", Tag.NULL));
        }

        @Override
        public void visitRegex(Pattern value2) {
            throw new RendererException(String.format("Values of type `Regex` cannot be rendered as YAML. Value: %s", value2));
        }

        private void doVisitIterable(Iterable<?> iterable, @Nullable String tag) {
            YamlRenderer.this.emitter.emit(new SequenceStartEvent(Optional.empty(), Optional.ofNullable(tag), true, FlowStyle.BLOCK));
            for (Object elem : iterable) {
                this.visit(elem);
            }
            YamlRenderer.this.emitter.emit(new SequenceEndEvent(Optional.empty(), Optional.empty()));
        }

        private void doVisitProperties(Map<String, ?> properties) {
            YamlRenderer.this.emitter.emit(new MappingStartEvent(Optional.empty(), Optional.empty(), true, FlowStyle.BLOCK));
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                Object value2 = entry.getValue();
                if (YamlRenderer.this.omitNullProperties && value2 instanceof PNull) continue;
                YamlRenderer.this.emitter.emit(YamlUtils.stringScalar(entry.getKey(), YamlRenderer.this.resolver));
                this.visit(value2);
            }
            YamlRenderer.this.emitter.emit(new MappingEndEvent(Optional.empty(), Optional.empty()));
        }
    }
}

