/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.pkl.core.DataSize;
import org.pkl.core.Duration;
import org.pkl.core.PClass;
import org.pkl.core.PModule;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.Pair;
import org.pkl.core.TypeAlias;
import org.pkl.core.Value;
import org.pkl.core.util.Nullable;

public final class PClassInfo<T>
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final String MODULE_CLASS_NAME = "ModuleClass";
    public static final URI pklBaseUri = URI.create("pkl:base");
    public static final URI pklSemverUri = URI.create("pkl:semver");
    public static final URI pklSettingsUri = URI.create("pkl:settings");
    public static final URI pklProjectUri = URI.create("pkl:Project");
    public static final PClassInfo<Void> Any = PClassInfo.pklBaseClassInfo("Any", Void.class);
    public static final PClassInfo<PNull> Null = PClassInfo.pklBaseClassInfo("Null", PNull.class);
    public static final PClassInfo<String> String = PClassInfo.pklBaseClassInfo("String", String.class);
    public static final PClassInfo<Boolean> Boolean = PClassInfo.pklBaseClassInfo("Boolean", java.lang.Boolean.TYPE);
    public static final PClassInfo<Void> Number = PClassInfo.pklBaseClassInfo("Number", Void.class);
    public static final PClassInfo<Long> Int = PClassInfo.pklBaseClassInfo("Int", Long.TYPE);
    public static final PClassInfo<Double> Float = PClassInfo.pklBaseClassInfo("Float", Double.TYPE);
    public static final PClassInfo<Duration> Duration = PClassInfo.pklBaseClassInfo("Duration", Duration.class);
    public static final PClassInfo<DataSize> DataSize = PClassInfo.pklBaseClassInfo("DataSize", DataSize.class);
    public static final PClassInfo<Pair> Pair = PClassInfo.pklBaseClassInfo("Pair", Pair.class);
    public static final PClassInfo<Void> Collection = PClassInfo.pklBaseClassInfo("Collection", Void.class);
    public static final PClassInfo<ArrayList> List = PClassInfo.pklBaseClassInfo("List", ArrayList.class);
    public static final PClassInfo<LinkedHashSet> Set = PClassInfo.pklBaseClassInfo("Set", LinkedHashSet.class);
    public static final PClassInfo<LinkedHashMap> Map = PClassInfo.pklBaseClassInfo("Map", LinkedHashMap.class);
    public static final PClassInfo<PObject> Object = PClassInfo.pklBaseClassInfo("Object", PObject.class);
    public static final PClassInfo<PObject> Dynamic = PClassInfo.pklBaseClassInfo("Dynamic", PObject.class);
    public static final PClassInfo<PObject> Typed = PClassInfo.pklBaseClassInfo("Typed", PObject.class);
    public static final PClassInfo<ArrayList> Listing = PClassInfo.pklBaseClassInfo("Listing", ArrayList.class);
    public static final PClassInfo<LinkedHashMap> Mapping = PClassInfo.pklBaseClassInfo("Mapping", LinkedHashMap.class);
    public static final PClassInfo<PModule> Module = PClassInfo.pklBaseClassInfo("Module", PModule.class);
    public static final PClassInfo<PObject> ModuleOutput = PClassInfo.pklBaseClassInfo("ModuleOutput", PObject.class);
    public static final PClassInfo<PClass> Class = PClassInfo.pklBaseClassInfo("Class", PClass.class);
    public static final PClassInfo<TypeAlias> TypeAlias = PClassInfo.pklBaseClassInfo("TypeAlias", TypeAlias.class);
    public static final PClassInfo<Pattern> Regex = PClassInfo.pklBaseClassInfo("Regex", Pattern.class);
    public static final PClassInfo<PObject> Deprecated = PClassInfo.pklBaseClassInfo("Deprecated", PObject.class);
    public static final PClassInfo<PObject> AlsoKnownAs = PClassInfo.pklBaseClassInfo("AlsoKnownAs", PObject.class);
    public static final PClassInfo<PObject> Unlisted = PClassInfo.pklBaseClassInfo("Unlisted", PObject.class);
    public static final PClassInfo<PObject> DocExample = PClassInfo.pklBaseClassInfo("DocExample", PObject.class);
    public static final PClassInfo<PObject> PcfRenderDirective = PClassInfo.pklBaseClassInfo("PcfRenderDirective", PObject.class);
    public static final PClassInfo<PObject> ModuleInfo = PClassInfo.pklBaseClassInfo("ModuleInfo", PObject.class);
    public static final PClassInfo<PObject> Version = new PClassInfo<PObject>("pkl.semver", "Version", PObject.class, pklSemverUri);
    public static final PClassInfo<PObject> Project = new PClassInfo<PObject>("pkl.Project", "ModuleClass", PObject.class, pklProjectUri);
    public static final PClassInfo<PObject> Settings = new PClassInfo<PObject>("pkl.settings", "ModuleClass", PObject.class, pklSettingsUri);
    public static final PClassInfo<Object> Unavailable = new PClassInfo<Object>("unavailable", "unavailable", Object.class, URI.create("pkl:unavailable"));
    private static final Map<String, PClassInfo<?>> pooledPklBaseClassInfos = java.util.Map.ofEntries(java.util.Map.entry(PClassInfo.Any.className, Any), java.util.Map.entry(PClassInfo.Null.className, Null), java.util.Map.entry(PClassInfo.Boolean.className, Boolean), java.util.Map.entry(PClassInfo.String.className, String), java.util.Map.entry(PClassInfo.Number.className, Number), java.util.Map.entry(PClassInfo.Int.className, Int), java.util.Map.entry(PClassInfo.Float.className, Float), java.util.Map.entry(PClassInfo.Duration.className, Duration), java.util.Map.entry(PClassInfo.DataSize.className, DataSize), java.util.Map.entry(PClassInfo.Pair.className, Pair), java.util.Map.entry(PClassInfo.Collection.className, Collection), java.util.Map.entry(PClassInfo.List.className, List), java.util.Map.entry(PClassInfo.Set.className, Set), java.util.Map.entry(PClassInfo.Map.className, Map), java.util.Map.entry(PClassInfo.Object.className, Object), java.util.Map.entry(PClassInfo.Dynamic.className, Dynamic), java.util.Map.entry(PClassInfo.Typed.className, Typed), java.util.Map.entry(PClassInfo.Listing.className, Listing), java.util.Map.entry(PClassInfo.Mapping.className, Mapping), java.util.Map.entry(PClassInfo.Module.className, Module), java.util.Map.entry(PClassInfo.ModuleOutput.className, ModuleOutput), java.util.Map.entry(PClassInfo.Class.className, Class), java.util.Map.entry(PClassInfo.TypeAlias.className, TypeAlias), java.util.Map.entry(PClassInfo.Regex.className, Regex), java.util.Map.entry(PClassInfo.Deprecated.className, Deprecated), java.util.Map.entry(PClassInfo.AlsoKnownAs.className, AlsoKnownAs), java.util.Map.entry(PClassInfo.Unlisted.className, Unlisted), java.util.Map.entry(PClassInfo.DocExample.className, DocExample), java.util.Map.entry(PClassInfo.PcfRenderDirective.className, PcfRenderDirective));
    private final String moduleName;
    private final String className;
    private final URI moduleUri;
    private final String qualifiedName;
    private final Class<T> javaClass;

    public static PClassInfo<?> get(String moduleName, String className, URI moduleUri) {
        PClassInfo<?> classInfo;
        if (moduleName.equals("pkl.base") && (classInfo = pooledPklBaseClassInfos.get(className)) != null) {
            return classInfo;
        }
        return new PClassInfo<PObject>(moduleName, className, PObject.class, moduleUri);
    }

    public static PClassInfo<?> forModuleClass(String moduleName, URI moduleUri) {
        return PClassInfo.get(moduleName, MODULE_CLASS_NAME, moduleUri);
    }

    public static <T> PClassInfo<T> forValue(T value2) {
        if (value2 instanceof Value) {
            Value v = (Value)value2;
            return v.getClassInfo();
        }
        if (value2 instanceof String) {
            return String;
        }
        if (value2 instanceof Boolean) {
            return Boolean;
        }
        if (value2 instanceof Long) {
            return Int;
        }
        if (value2 instanceof Double) {
            return Float;
        }
        if (value2 instanceof List) {
            return List;
        }
        if (value2 instanceof Set) {
            return Set;
        }
        if (value2 instanceof Map) {
            return Map;
        }
        if (value2 instanceof Pattern) {
            return Regex;
        }
        throw new IllegalArgumentException("Not a Pkl value: " + value2);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getSimpleName() {
        return this.className;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getDisplayName() {
        return this.moduleName.equals("pkl.base") ? this.className : (this.isModuleClass() ? this.moduleName : this.qualifiedName);
    }

    public boolean isModuleClass() {
        return this.className.equals(MODULE_CLASS_NAME);
    }

    public Class<T> getJavaClass() {
        return this.javaClass;
    }

    public boolean isExternalClass() {
        return this.javaClass != PObject.class;
    }

    public boolean isStandardLibraryClass() {
        return this.moduleName.startsWith("pkl.");
    }

    public boolean isConcreteCollectionClass() {
        return this == List || this == Set;
    }

    public boolean isExactClassOf(Object value2) {
        Class<?> clazz = value2.getClass();
        if (clazz != this.javaClass) {
            return false;
        }
        if (clazz != PObject.class) {
            return true;
        }
        PObject pObject = (PObject)value2;
        return pObject.getClassInfo().equals(this);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PClassInfo)) {
            return false;
        }
        PClassInfo other = (PClassInfo)obj;
        return this.qualifiedName.equals(other.qualifiedName);
    }

    public int hashCode() {
        return this.qualifiedName.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    private PClassInfo(String moduleName, String className, Class<T> javaClass, URI moduleUri) {
        this.moduleName = moduleName;
        this.className = className;
        this.moduleUri = moduleUri;
        this.qualifiedName = moduleName + "#" + className;
        this.javaClass = javaClass;
    }

    private static <T> PClassInfo<T> pklBaseClassInfo(String className, Class<T> javaType) {
        return new PClassInfo<T>("pkl.base", className, javaType, pklBaseUri);
    }

    public URI getModuleUri() {
        return this.moduleUri;
    }
}

