/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.pkl.core.util.Nullable;

public enum DurationUnit {
    NANOS(1L, "ns"),
    MICROS(1000L, "us"),
    MILLIS(1000000L, "ms"),
    SECONDS(1000000000L, "s"),
    MINUTES(60000000000L, "min"),
    HOURS(3600000000000L, "h"),
    DAYS(86400000000000L, "d");

    private final long nanos;
    private final String symbol;

    private DurationUnit(long nanos, String symbol) {
        this.nanos = nanos;
        this.symbol = symbol;
    }

    @Nullable
    public static DurationUnit parse(String symbol) {
        return switch (symbol) {
            case "ns" -> NANOS;
            case "us" -> MICROS;
            case "ms" -> MILLIS;
            case "s" -> SECONDS;
            case "min" -> MINUTES;
            case "h" -> HOURS;
            case "d" -> DAYS;
            default -> null;
        };
    }

    public String getSymbol() {
        return this.symbol;
    }

    public long getNanos() {
        return this.nanos;
    }

    public ChronoUnit toChronoUnit() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NANOS -> ChronoUnit.NANOS;
            case MICROS -> ChronoUnit.MICROS;
            case MILLIS -> ChronoUnit.MILLIS;
            case SECONDS -> ChronoUnit.SECONDS;
            case MINUTES -> ChronoUnit.MINUTES;
            case HOURS -> ChronoUnit.HOURS;
            case DAYS -> ChronoUnit.DAYS;
        };
    }

    public TimeUnit toTimeUnit() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NANOS -> TimeUnit.NANOSECONDS;
            case MICROS -> TimeUnit.MICROSECONDS;
            case MILLIS -> TimeUnit.MILLISECONDS;
            case SECONDS -> TimeUnit.SECONDS;
            case MINUTES -> TimeUnit.MINUTES;
            case HOURS -> TimeUnit.HOURS;
            case DAYS -> TimeUnit.DAYS;
        };
    }

    public String toString() {
        return this.symbol;
    }
}

