/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.commons;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006\u001a\n\u0010\b\u001a\u00020\t*\u00020\u0006\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0006\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"uriLike", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "windowsPathLike", "shlex", "", "", "input", "toPath", "Ljava/nio/file/Path;", "toUri", "Ljava/net/URI;", "pkl-commons"})
public final class StringsKt {
    private static final Pattern uriLike = Pattern.compile("\\w+:[^\\\\].*");
    private static final Pattern windowsPathLike = Pattern.compile("\\w:\\\\.*");

    @NotNull
    public static final Path toPath(@NotNull String $this$toPath) {
        Intrinsics.checkNotNullParameter($this$toPath, "<this>");
        Path path2 = Path.of($this$toPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "of(this)");
        return path2;
    }

    @NotNull
    public static final URI toUri(@NotNull String $this$toUri) {
        Intrinsics.checkNotNullParameter($this$toUri, "<this>");
        if (uriLike.matcher($this$toUri).matches()) {
            return new URI($this$toUri);
        }
        if (windowsPathLike.matcher($this$toUri).matches()) {
            URI uRI = new File($this$toUri).toURI();
            Intrinsics.checkNotNullExpressionValue(uRI, "File(this).toURI()");
            return uRI;
        }
        return new URI(null, null, $this$toUri, null);
    }

    @NotNull
    public static final List<String> shlex(@NotNull String input) {
        Intrinsics.checkNotNullParameter(input, "input");
        List result = new ArrayList();
        boolean inEscape = false;
        Character quote = null;
        int lastCloseQuoteIndex = Integer.MIN_VALUE;
        StringBuilder current2 = new StringBuilder();
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char c;
            int idx = i;
            char c2 = input.charAt(i);
            if (inEscape) {
                inEscape = false;
                current2.append(c2);
                continue;
            }
            if (c2 == '\\') {
                Character c3 = quote;
                c = '\'';
                if (c3 == null || c3.charValue() != c) {
                    inEscape = true;
                    continue;
                }
            }
            Character c4 = quote;
            c = c2;
            if (c4 != null && c4.charValue() == c) {
                quote = null;
                lastCloseQuoteIndex = idx;
                continue;
            }
            if (quote == null && (c2 == '\'' || c2 == '\"')) {
                quote = Character.valueOf(c2);
                continue;
            }
            if (quote == null && CharsKt.isWhitespace(c2)) {
                if (!(((CharSequence)current2).length() > 0) && lastCloseQuoteIndex != idx - 1) continue;
                String string = current2.toString();
                Intrinsics.checkNotNullExpressionValue(string, "current.toString()");
                result.add(string);
                kotlin.text.StringsKt.clear(current2);
                continue;
            }
            current2.append(c2);
        }
        if (((CharSequence)current2).length() > 0 || lastCloseQuoteIndex == input.length() - 1) {
            String string = current2.toString();
            Intrinsics.checkNotNullExpressionValue(string, "current.toString()");
            result.add(string);
        }
        return result;
    }
}

