/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.host.HostClassCache;
import com.oracle.truffle.host.HostContext;
import com.oracle.truffle.host.HostEngineException;
import com.oracle.truffle.host.HostTargetMapping;
import com.oracle.truffle.host.HostTargetMappingNodeGen;
import com.oracle.truffle.host.HostToTypeNode;
import java.util.function.Function;
import java.util.function.Predicate;

@GenerateUncached
@GenerateInline
@GenerateCached
abstract class HostTargetMappingNode
extends Node {
    public static final Object NO_RESULT = new Object();

    HostTargetMappingNode() {
    }

    abstract Object execute(Node var1, Object var2, Class<?> var3, HostContext var4, InteropLibrary var5, boolean var6, int var7, int var8);

    @Specialization(guards={"targetType != null"})
    @ExplodeLoop
    protected Object doCached(Object operand, Class<?> targetType, HostContext context2, InteropLibrary interop, boolean checkOnly, int startPriority, int endPriority, @Cached(value="getMappings(context, targetType)", dimensions=1, neverDefault=true) HostTargetMapping[] mappings, @Cached(value="createMappingNodes(mappings)", neverDefault=true) SingleMappingNode[] mappingNodes) {
        assert (startPriority <= endPriority);
        Object result = NO_RESULT;
        if (mappingNodes != null) {
            for (int i = 0; i < mappingNodes.length; ++i) {
                HostTargetMapping mapping = mappings[i];
                if (mapping.hostPriority >= startPriority && (mapping.hostPriority > endPriority || (result = mappingNodes[i].execute(operand, mappings[i], context2, interop, checkOnly)) != NO_RESULT)) break;
            }
        }
        return result;
    }

    @Specialization(replaces={"doCached"})
    @CompilerDirectives.TruffleBoundary
    protected Object doUncached(Object operand, Class<?> targetType, HostContext hostContext, InteropLibrary interop, boolean checkOnly, int startPriority, int endPriority) {
        assert (startPriority <= endPriority);
        Object result = NO_RESULT;
        HostTargetMapping[] mappings = HostTargetMappingNode.getMappings(hostContext, targetType);
        if (mappings != null) {
            SingleMappingNode uncachedNode = HostTargetMappingNodeGen.SingleMappingNodeGen.getUncached();
            for (int i = 0; i < mappings.length; ++i) {
                HostTargetMapping mapping = mappings[i];
                if (mapping.hostPriority >= startPriority && (mapping.hostPriority > endPriority || (result = uncachedNode.execute(operand, mappings[i], hostContext, interop, checkOnly)) != NO_RESULT)) break;
            }
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    static HostTargetMapping[] getMappings(HostContext hostContext, Class<?> targetType) {
        if (hostContext == null) {
            return HostClassCache.EMPTY_MAPPINGS;
        }
        return hostContext.getHostClassCache().getMappings(targetType);
    }

    @CompilerDirectives.TruffleBoundary
    static SingleMappingNode[] createMappingNodes(HostTargetMapping[] mappings) {
        if (mappings == null) {
            return null;
        }
        SingleMappingNode[] nodes = new SingleMappingNode[mappings.length];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = HostTargetMappingNodeGen.SingleMappingNodeGen.create();
        }
        return nodes;
    }

    static HostTargetMappingNode create() {
        return HostTargetMappingNodeGen.create();
    }

    static HostTargetMappingNode getUncached() {
        return HostTargetMappingNodeGen.getUncached();
    }

    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class SingleMappingNode
    extends Node {
        SingleMappingNode() {
        }

        abstract Object execute(Object var1, HostTargetMapping var2, HostContext var3, InteropLibrary var4, boolean var5);

        @Specialization
        protected static Object doDefault(Object receiver, HostTargetMapping cachedMapping, HostContext context2, InteropLibrary interop, boolean checkOnly, @Bind(value="this") Node node, @Cached InlinedConditionProfile acceptsProfile, @Cached(value="allowsImplementation(context, cachedMapping.sourceType)", allowUncached=true) Boolean allowsImplementation, @Cached(inline=true) HostToTypeNode toHostRecursive) {
            CompilerAsserts.partialEvaluationConstant(checkOnly);
            Object convertedValue = NO_RESULT;
            if (acceptsProfile.profile(node, HostToTypeNode.canConvert(node, receiver, cachedMapping.sourceType, cachedMapping.sourceType, allowsImplementation, context2, 8, interop, null))) {
                if (!checkOnly || cachedMapping.accepts != null) {
                    convertedValue = toHostRecursive.execute(node, context2, receiver, cachedMapping.sourceType, cachedMapping.sourceType, false);
                }
            } else {
                return NO_RESULT;
            }
            if (cachedMapping.accepts != null && !SingleMappingNode.checkPredicate(context2, convertedValue, cachedMapping.accepts)) {
                return NO_RESULT;
            }
            if (checkOnly) {
                return Boolean.TRUE;
            }
            return SingleMappingNode.convert(context2, cachedMapping.converter, convertedValue);
        }

        static boolean allowsImplementation(HostContext context2, Class<?> type) {
            return HostToTypeNode.allowsImplementation(context2, type);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object convert(HostContext context2, Function<Object, Object> converter, Object value2) {
            try {
                return converter.apply(value2);
            }
            catch (ClassCastException t) {
                throw HostEngineException.classCast(context2.access, t.getMessage());
            }
            catch (Throwable t) {
                throw context2.hostToGuestException(t);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean checkPredicate(HostContext context2, Object convertedValue, Predicate<Object> predicate) {
            try {
                return predicate.test(convertedValue);
            }
            catch (Throwable t) {
                throw context2.hostToGuestException(t);
            }
        }
    }
}

