//===----------------------------------------------------------------------===//
// Copyright © 2024 Apple Inc. and the Pkl project authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//===----------------------------------------------------------------------===//

/// Utilities for generating shell scripts.
@ModuleInfo { minPklVersion = "0.27.0" }
module pkl.shell

/// Escapes [str] by enclosing it in single quotes.
///
/// Also handles single quotes occurring within [str].
function escapeWithSingleQuotes(str: String): String =
  let (processChar = (acc, ch) ->
      if (acc.isEmpty)
        List(List(ch))
      else if (acc.last.last != "'" && ch != "'")
        acc.replace(acc.lastIndex, acc.last.add(ch))
      else
        acc.add(List(ch)))
    let (grouped = str.chars.fold(List(), processChar))
      grouped
        .map((chSeq) ->
            if (chSeq == List("'")) #"\'"#
            else "'\(chSeq.join(""))'")
        .join("")
