//===----------------------------------------------------------------------===//
// Copyright © 2024 Apple Inc. and the Pkl project authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//===----------------------------------------------------------------------===//

/// Information about the platform that the current program runs on.
@ModuleInfo { minPklVersion = "0.27.0" }
module pkl.platform

/// The platform that the current program runs on.
external current: Platform

/// The platform that a program runs on.
class Platform {
  /// The language implementation of this platform.
  language: Language

  /// The language runtime of this platform.
  runtime: Runtime

  /// The virtual machine of this platform.
  virtualMachine: VirtualMachine

  /// The operating system of this platform.
  operatingSystem: OperatingSystem

  /// The processor of this platform.
  processor: Processor
}

/// The language implementation of a platform.
class Language {
  /// The version of this language implementation.
  version: String
}

/// The language runtime of a platform.
class Runtime {
  /// The name of this runtime.
  name: String

  /// The version of this runtime.
  version: String
}

/// The virtual machine of a platform.
class VirtualMachine {
  /// The name of this virtual machine.
  name: String

  /// The version of this virtual machine.
  version: String
}

/// The operating system of a platform.
class OperatingSystem {
  /// The name of this operating system.
  name: "macOS"|"Linux"|"Windows"|String

  /// The version of this operating system.
  version: String
}

/// The processor of a platform.
class Processor {
  /// The instruction set architecture of this processor.
  architecture: String
}
